/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CodeSigningMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the method to use when code signing a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigning implements StructuredPojo, ToCopyableBuilder<CodeSigning.Builder, CodeSigning> {
    private final String awsSignerJobId;

    private final StartSigningJobParameter startSigningJobParameter;

    private final CustomCodeSigning customCodeSigning;

    private CodeSigning(BuilderImpl builder) {
        this.awsSignerJobId = builder.awsSignerJobId;
        this.startSigningJobParameter = builder.startSigningJobParameter;
        this.customCodeSigning = builder.customCodeSigning;
    }

    /**
     * <p>
     * The ID of the AWSSignerJob which was created to sign the file.
     * </p>
     * 
     * @return The ID of the AWSSignerJob which was created to sign the file.
     */
    public String awsSignerJobId() {
        return awsSignerJobId;
    }

    /**
     * <p>
     * Describes the code-signing job.
     * </p>
     * 
     * @return Describes the code-signing job.
     */
    public StartSigningJobParameter startSigningJobParameter() {
        return startSigningJobParameter;
    }

    /**
     * <p>
     * A custom method for code signing a file.
     * </p>
     * 
     * @return A custom method for code signing a file.
     */
    public CustomCodeSigning customCodeSigning() {
        return customCodeSigning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsSignerJobId());
        hashCode = 31 * hashCode + Objects.hashCode(startSigningJobParameter());
        hashCode = 31 * hashCode + Objects.hashCode(customCodeSigning());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigning)) {
            return false;
        }
        CodeSigning other = (CodeSigning) obj;
        return Objects.equals(awsSignerJobId(), other.awsSignerJobId())
                && Objects.equals(startSigningJobParameter(), other.startSigningJobParameter())
                && Objects.equals(customCodeSigning(), other.customCodeSigning());
    }

    @Override
    public String toString() {
        return ToString.builder("CodeSigning").add("AwsSignerJobId", awsSignerJobId())
                .add("StartSigningJobParameter", startSigningJobParameter()).add("CustomCodeSigning", customCodeSigning())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsSignerJobId":
            return Optional.ofNullable(clazz.cast(awsSignerJobId()));
        case "startSigningJobParameter":
            return Optional.ofNullable(clazz.cast(startSigningJobParameter()));
        case "customCodeSigning":
            return Optional.ofNullable(clazz.cast(customCodeSigning()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CodeSigning> {
        /**
         * <p>
         * The ID of the AWSSignerJob which was created to sign the file.
         * </p>
         * 
         * @param awsSignerJobId
         *        The ID of the AWSSignerJob which was created to sign the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSignerJobId(String awsSignerJobId);

        /**
         * <p>
         * Describes the code-signing job.
         * </p>
         * 
         * @param startSigningJobParameter
         *        Describes the code-signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSigningJobParameter(StartSigningJobParameter startSigningJobParameter);

        /**
         * <p>
         * Describes the code-signing job.
         * </p>
         * This is a convenience that creates an instance of the {@link StartSigningJobParameter.Builder} avoiding the
         * need to create one manually via {@link StartSigningJobParameter#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartSigningJobParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #startSigningJobParameter(StartSigningJobParameter)}.
         * 
         * @param startSigningJobParameter
         *        a consumer that will call methods on {@link StartSigningJobParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSigningJobParameter(StartSigningJobParameter)
         */
        default Builder startSigningJobParameter(Consumer<StartSigningJobParameter.Builder> startSigningJobParameter) {
            return startSigningJobParameter(StartSigningJobParameter.builder().applyMutation(startSigningJobParameter).build());
        }

        /**
         * <p>
         * A custom method for code signing a file.
         * </p>
         * 
         * @param customCodeSigning
         *        A custom method for code signing a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCodeSigning(CustomCodeSigning customCodeSigning);

        /**
         * <p>
         * A custom method for code signing a file.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomCodeSigning.Builder} avoiding the need to
         * create one manually via {@link CustomCodeSigning#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomCodeSigning.Builder#build()} is called immediately and its
         * result is passed to {@link #customCodeSigning(CustomCodeSigning)}.
         * 
         * @param customCodeSigning
         *        a consumer that will call methods on {@link CustomCodeSigning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCodeSigning(CustomCodeSigning)
         */
        default Builder customCodeSigning(Consumer<CustomCodeSigning.Builder> customCodeSigning) {
            return customCodeSigning(CustomCodeSigning.builder().applyMutation(customCodeSigning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String awsSignerJobId;

        private StartSigningJobParameter startSigningJobParameter;

        private CustomCodeSigning customCodeSigning;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigning model) {
            awsSignerJobId(model.awsSignerJobId);
            startSigningJobParameter(model.startSigningJobParameter);
            customCodeSigning(model.customCodeSigning);
        }

        public final String getAwsSignerJobId() {
            return awsSignerJobId;
        }

        @Override
        public final Builder awsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
            return this;
        }

        public final void setAwsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
        }

        public final StartSigningJobParameter.Builder getStartSigningJobParameter() {
            return startSigningJobParameter != null ? startSigningJobParameter.toBuilder() : null;
        }

        @Override
        public final Builder startSigningJobParameter(StartSigningJobParameter startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter;
            return this;
        }

        public final void setStartSigningJobParameter(StartSigningJobParameter.BuilderImpl startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter != null ? startSigningJobParameter.build() : null;
        }

        public final CustomCodeSigning.Builder getCustomCodeSigning() {
            return customCodeSigning != null ? customCodeSigning.toBuilder() : null;
        }

        @Override
        public final Builder customCodeSigning(CustomCodeSigning customCodeSigning) {
            this.customCodeSigning = customCodeSigning;
            return this;
        }

        public final void setCustomCodeSigning(CustomCodeSigning.BuilderImpl customCodeSigning) {
            this.customCodeSigning = customCodeSigning != null ? customCodeSigning.build() : null;
        }

        @Override
        public CodeSigning build() {
            return new CodeSigning(this);
        }
    }
}
