/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CodeSigningCertificateChainMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the certificate chain being used when code signing a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigningCertificateChain implements StructuredPojo,
        ToCopyableBuilder<CodeSigningCertificateChain.Builder, CodeSigningCertificateChain> {
    private final String certificateName;

    private final String inlineDocument;

    private CodeSigningCertificateChain(BuilderImpl builder) {
        this.certificateName = builder.certificateName;
        this.inlineDocument = builder.inlineDocument;
    }

    /**
     * <p>
     * The name of the certificate.
     * </p>
     * 
     * @return The name of the certificate.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * A base64 encoded binary representation of the code signing certificate chain.
     * </p>
     * 
     * @return A base64 encoded binary representation of the code signing certificate chain.
     */
    public String inlineDocument() {
        return inlineDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(inlineDocument());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningCertificateChain)) {
            return false;
        }
        CodeSigningCertificateChain other = (CodeSigningCertificateChain) obj;
        return Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(inlineDocument(), other.inlineDocument());
    }

    @Override
    public String toString() {
        return ToString.builder("CodeSigningCertificateChain").add("CertificateName", certificateName())
                .add("InlineDocument", inlineDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "inlineDocument":
            return Optional.ofNullable(clazz.cast(inlineDocument()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningCertificateChainMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CodeSigningCertificateChain> {
        /**
         * <p>
         * The name of the certificate.
         * </p>
         * 
         * @param certificateName
         *        The name of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * A base64 encoded binary representation of the code signing certificate chain.
         * </p>
         * 
         * @param inlineDocument
         *        A base64 encoded binary representation of the code signing certificate chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineDocument(String inlineDocument);
    }

    static final class BuilderImpl implements Builder {
        private String certificateName;

        private String inlineDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningCertificateChain model) {
            certificateName(model.certificateName);
            inlineDocument(model.inlineDocument);
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getInlineDocument() {
            return inlineDocument;
        }

        @Override
        public final Builder inlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
            return this;
        }

        public final void setInlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
        }

        @Override
        public CodeSigningCertificateChain build() {
            return new CodeSigningCertificateChain(this);
        }
    }
}
