/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobResponse extends IotResponse implements
        ToCopyableBuilder<CreateJobResponse.Builder, CreateJobResponse> {
    private final String jobArn;

    private final String jobId;

    private final String description;

    private CreateJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The job ARN.
     * </p>
     * 
     * @return The job ARN.
     */
    public String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job.
     * </p>
     * 
     * @return The unique identifier you assigned to this job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job description.
     * </p>
     * 
     * @return The job description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobResponse)) {
            return false;
        }
        CreateJobResponse other = (CreateJobResponse) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateJobResponse").add("JobArn", jobArn()).add("JobId", jobId())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, CreateJobResponse> {
        /**
         * <p>
         * The job ARN.
         * </p>
         * 
         * @param jobArn
         *        The job ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The unique identifier you assigned to this job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job description.
         * </p>
         * 
         * @param description
         *        The job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String jobArn;

        private String jobId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobResponse model) {
            super(model);
            jobArn(model.jobArn);
            jobId(model.jobId);
            description(model.description);
        }

        public final String getJobArn() {
            return jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public CreateJobResponse build() {
            return new CreateJobResponse(this);
        }
    }
}
