/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaUpdateResponse extends IotResponse implements
        ToCopyableBuilder<CreateOtaUpdateResponse.Builder, CreateOtaUpdateResponse> {
    private final String otaUpdateId;

    private final String awsIotJobId;

    private final String otaUpdateArn;

    private final String awsIotJobArn;

    private final String otaUpdateStatus;

    private CreateOtaUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.awsIotJobId = builder.awsIotJobId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.otaUpdateStatus = builder.otaUpdateStatus;
    }

    /**
     * <p>
     * The OTA update ID.
     * </p>
     * 
     * @return The OTA update ID.
     */
    public String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The AWS IoT job ID associated with the OTA update.
     * </p>
     * 
     * @return The AWS IoT job ID associated with the OTA update.
     */
    public String awsIotJobId() {
        return awsIotJobId;
    }

    /**
     * <p>
     * The OTA update ARN.
     * </p>
     * 
     * @return The OTA update ARN.
     */
    public String otaUpdateArn() {
        return otaUpdateArn;
    }

    /**
     * <p>
     * The AWS IoT job ARN associated with the OTA update.
     * </p>
     * 
     * @return The AWS IoT job ARN associated with the OTA update.
     */
    public String awsIotJobArn() {
        return awsIotJobArn;
    }

    /**
     * <p>
     * The OTA update status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update status.
     * @see OTAUpdateStatus
     */
    public OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(otaUpdateStatus);
    }

    /**
     * <p>
     * The OTA update status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update status.
     * @see OTAUpdateStatus
     */
    public String otaUpdateStatusAsString() {
        return otaUpdateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateResponse)) {
            return false;
        }
        CreateOtaUpdateResponse other = (CreateOtaUpdateResponse) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(awsIotJobId(), other.awsIotJobId())
                && Objects.equals(otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(awsIotJobArn(), other.awsIotJobArn())
                && Objects.equals(otaUpdateStatusAsString(), other.otaUpdateStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateOtaUpdateResponse").add("OtaUpdateId", otaUpdateId()).add("AwsIotJobId", awsIotJobId())
                .add("OtaUpdateArn", otaUpdateArn()).add("AwsIotJobArn", awsIotJobArn())
                .add("OtaUpdateStatus", otaUpdateStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "awsIotJobId":
            return Optional.ofNullable(clazz.cast(awsIotJobId()));
        case "otaUpdateArn":
            return Optional.ofNullable(clazz.cast(otaUpdateArn()));
        case "awsIotJobArn":
            return Optional.ofNullable(clazz.cast(awsIotJobArn()));
        case "otaUpdateStatus":
            return Optional.ofNullable(clazz.cast(otaUpdateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, CreateOtaUpdateResponse> {
        /**
         * <p>
         * The OTA update ID.
         * </p>
         * 
         * @param otaUpdateId
         *        The OTA update ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The AWS IoT job ID associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobId
         *        The AWS IoT job ID associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobId(String awsIotJobId);

        /**
         * <p>
         * The OTA update ARN.
         * </p>
         * 
         * @param otaUpdateArn
         *        The OTA update ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateArn(String otaUpdateArn);

        /**
         * <p>
         * The AWS IoT job ARN associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobArn
         *        The AWS IoT job ARN associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobArn(String awsIotJobArn);

        /**
         * <p>
         * The OTA update status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(String otaUpdateStatus);

        /**
         * <p>
         * The OTA update status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String otaUpdateId;

        private String awsIotJobId;

        private String otaUpdateArn;

        private String awsIotJobArn;

        private String otaUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateResponse model) {
            super(model);
            otaUpdateId(model.otaUpdateId);
            awsIotJobId(model.awsIotJobId);
            otaUpdateArn(model.otaUpdateArn);
            awsIotJobArn(model.awsIotJobArn);
            otaUpdateStatus(model.otaUpdateStatus);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getAwsIotJobId() {
            return awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        public final String getOtaUpdateArn() {
            return otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final String getAwsIotJobArn() {
            return awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        public final String getOtaUpdateStatus() {
            return otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus.toString());
            return this;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public CreateOtaUpdateResponse build() {
            return new CreateOtaUpdateResponse(this);
        }
    }
}
