/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoleAliasResponse extends IotResponse implements
        ToCopyableBuilder<CreateRoleAliasResponse.Builder, CreateRoleAliasResponse> {
    private final String roleAlias;

    private final String roleAliasArn;

    private CreateRoleAliasResponse(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleAliasArn = builder.roleAliasArn;
    }

    /**
     * <p>
     * The role alias.
     * </p>
     * 
     * @return The role alias.
     */
    public String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The role alias ARN.
     * </p>
     * 
     * @return The role alias ARN.
     */
    public String roleAliasArn() {
        return roleAliasArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleAliasResponse)) {
            return false;
        }
        CreateRoleAliasResponse other = (CreateRoleAliasResponse) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleAliasArn(), other.roleAliasArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRoleAliasResponse").add("RoleAlias", roleAlias()).add("RoleAliasArn", roleAliasArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, CreateRoleAliasResponse> {
        /**
         * <p>
         * The role alias.
         * </p>
         * 
         * @param roleAlias
         *        The role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The role alias ARN.
         * </p>
         * 
         * @param roleAliasArn
         *        The role alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String roleAlias;

        private String roleAliasArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleAliasResponse model) {
            super(model);
            roleAlias(model.roleAlias);
            roleAliasArn(model.roleAliasArn);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        @Override
        public CreateRoleAliasResponse build() {
            return new CreateRoleAliasResponse(this);
        }
    }
}
