/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamResponse extends IotResponse implements
        ToCopyableBuilder<CreateStreamResponse.Builder, CreateStreamResponse> {
    private final String streamId;

    private final String streamArn;

    private final String description;

    private final Integer streamVersion;

    private CreateStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.description = builder.description;
        this.streamVersion = builder.streamVersion;
    }

    /**
     * <p>
     * The stream ID.
     * </p>
     * 
     * @return The stream ID.
     */
    public String streamId() {
        return streamId;
    }

    /**
     * <p>
     * The stream ARN.
     * </p>
     * 
     * @return The stream ARN.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * A description of the stream.
     * </p>
     * 
     * @return A description of the stream.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the stream.
     * </p>
     * 
     * @return The version of the stream.
     */
    public Integer streamVersion() {
        return streamVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(streamVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamResponse)) {
            return false;
        }
        CreateStreamResponse other = (CreateStreamResponse) obj;
        return Objects.equals(streamId(), other.streamId()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(description(), other.description()) && Objects.equals(streamVersion(), other.streamVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamResponse").add("StreamId", streamId()).add("StreamArn", streamArn())
                .add("Description", description()).add("StreamVersion", streamVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "streamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "streamVersion":
            return Optional.ofNullable(clazz.cast(streamVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, CreateStreamResponse> {
        /**
         * <p>
         * The stream ID.
         * </p>
         * 
         * @param streamId
         *        The stream ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * The stream ARN.
         * </p>
         * 
         * @param streamArn
         *        The stream ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * A description of the stream.
         * </p>
         * 
         * @param description
         *        A description of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the stream.
         * </p>
         * 
         * @param streamVersion
         *        The version of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamVersion(Integer streamVersion);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String streamId;

        private String streamArn;

        private String description;

        private Integer streamVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamResponse model) {
            super(model);
            streamId(model.streamId);
            streamArn(model.streamArn);
            description(model.description);
            streamVersion(model.streamVersion);
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getStreamVersion() {
            return streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        @Override
        public CreateStreamResponse build() {
            return new CreateStreamResponse(this);
        }
    }
}
