/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingGroupRequest extends IotRequest implements
        ToCopyableBuilder<CreateThingGroupRequest.Builder, CreateThingGroupRequest> {
    private final String thingGroupName;

    private final String parentGroupName;

    private final ThingGroupProperties thingGroupProperties;

    private CreateThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.parentGroupName = builder.parentGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
    }

    /**
     * <p>
     * The thing group name to create.
     * </p>
     * 
     * @return The thing group name to create.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The name of the parent thing group.
     * </p>
     * 
     * @return The name of the parent thing group.
     */
    public String parentGroupName() {
        return parentGroupName;
    }

    /**
     * <p>
     * The thing group properties.
     * </p>
     * 
     * @return The thing group properties.
     */
    public ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingGroupRequest)) {
            return false;
        }
        CreateThingGroupRequest other = (CreateThingGroupRequest) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName())
                && Objects.equals(parentGroupName(), other.parentGroupName())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateThingGroupRequest").add("ThingGroupName", thingGroupName())
                .add("ParentGroupName", parentGroupName()).add("ThingGroupProperties", thingGroupProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "parentGroupName":
            return Optional.ofNullable(clazz.cast(parentGroupName()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, CreateThingGroupRequest> {
        /**
         * <p>
         * The thing group name to create.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group name to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The name of the parent thing group.
         * </p>
         * 
         * @param parentGroupName
         *        The name of the parent thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupName(String parentGroupName);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * 
         * @param thingGroupProperties
         *        The thing group properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupProperties.Builder} avoiding the need
         * to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingGroupName;

        private String parentGroupName;

        private ThingGroupProperties thingGroupProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingGroupRequest model) {
            super(model);
            thingGroupName(model.thingGroupName);
            parentGroupName(model.parentGroupName);
            thingGroupProperties(model.thingGroupProperties);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getParentGroupName() {
            return parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingGroupRequest build() {
            return new CreateThingGroupRequest(this);
        }
    }
}
