/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<CreateThingGroupResponse.Builder, CreateThingGroupResponse> {
    private final String thingGroupName;

    private final String thingGroupArn;

    private final String thingGroupId;

    private CreateThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupArn = builder.thingGroupArn;
        this.thingGroupId = builder.thingGroupId;
    }

    /**
     * <p>
     * The thing group name.
     * </p>
     * 
     * @return The thing group name.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group ARN.
     * </p>
     * 
     * @return The thing group ARN.
     */
    public String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The thing group ID.
     * </p>
     * 
     * @return The thing group ID.
     */
    public String thingGroupId() {
        return thingGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingGroupResponse)) {
            return false;
        }
        CreateThingGroupResponse other = (CreateThingGroupResponse) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupArn(), other.thingGroupArn())
                && Objects.equals(thingGroupId(), other.thingGroupId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateThingGroupResponse").add("ThingGroupName", thingGroupName())
                .add("ThingGroupArn", thingGroupArn()).add("ThingGroupId", thingGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, CreateThingGroupResponse> {
        /**
         * <p>
         * The thing group name.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group ARN.
         * </p>
         * 
         * @param thingGroupArn
         *        The thing group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupArn;

        private String thingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingGroupResponse model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupArn(model.thingGroupArn);
            thingGroupId(model.thingGroupId);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        @Override
        public CreateThingGroupResponse build() {
            return new CreateThingGroupResponse(this);
        }
    }
}
