/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteScheduledAuditRequest extends IotRequest implements
        ToCopyableBuilder<DeleteScheduledAuditRequest.Builder, DeleteScheduledAuditRequest> {
    private final String scheduledAuditName;

    private DeleteScheduledAuditRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledAuditName = builder.scheduledAuditName;
    }

    /**
     * <p>
     * The name of the scheduled audit you want to delete.
     * </p>
     * 
     * @return The name of the scheduled audit you want to delete.
     */
    public String scheduledAuditName() {
        return scheduledAuditName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScheduledAuditRequest)) {
            return false;
        }
        DeleteScheduledAuditRequest other = (DeleteScheduledAuditRequest) obj;
        return Objects.equals(scheduledAuditName(), other.scheduledAuditName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteScheduledAuditRequest").add("ScheduledAuditName", scheduledAuditName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAuditName":
            return Optional.ofNullable(clazz.cast(scheduledAuditName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, DeleteScheduledAuditRequest> {
        /**
         * <p>
         * The name of the scheduled audit you want to delete.
         * </p>
         * 
         * @param scheduledAuditName
         *        The name of the scheduled audit you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditName(String scheduledAuditName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String scheduledAuditName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScheduledAuditRequest model) {
            super(model);
            scheduledAuditName(model.scheduledAuditName);
        }

        public final String getScheduledAuditName() {
            return scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteScheduledAuditRequest build() {
            return new DeleteScheduledAuditRequest(this);
        }
    }
}
