/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteV2LoggingLevelRequest extends IotRequest implements
        ToCopyableBuilder<DeleteV2LoggingLevelRequest.Builder, DeleteV2LoggingLevelRequest> {
    private final String targetType;

    private final String targetName;

    private DeleteV2LoggingLevelRequest(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * @see LogTargetType
     */
    public LogTargetType targetType() {
        return LogTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * @see LogTargetType
     */
    public String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The name of the resource for which you are configuring logging.
     * </p>
     * 
     * @return The name of the resource for which you are configuring logging.
     */
    public String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteV2LoggingLevelRequest)) {
            return false;
        }
        DeleteV2LoggingLevelRequest other = (DeleteV2LoggingLevelRequest) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetName(), other.targetName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteV2LoggingLevelRequest").add("TargetType", targetTypeAsString())
                .add("TargetName", targetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, DeleteV2LoggingLevelRequest> {
        /**
         * <p>
         * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * </p>
         * 
         * @param targetType
         *        The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * </p>
         * 
         * @param targetType
         *        The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(LogTargetType targetType);

        /**
         * <p>
         * The name of the resource for which you are configuring logging.
         * </p>
         * 
         * @param targetName
         *        The name of the resource for which you are configuring logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String targetType;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteV2LoggingLevelRequest model) {
            super(model);
            targetType(model.targetType);
            targetName(model.targetName);
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(LogTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetName() {
            return targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteV2LoggingLevelRequest build() {
            return new DeleteV2LoggingLevelRequest(this);
        }
    }
}
