/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.DeniedMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information that denied the authorization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Denied implements StructuredPojo, ToCopyableBuilder<Denied.Builder, Denied> {
    private final ImplicitDeny implicitDeny;

    private final ExplicitDeny explicitDeny;

    private Denied(BuilderImpl builder) {
        this.implicitDeny = builder.implicitDeny;
        this.explicitDeny = builder.explicitDeny;
    }

    /**
     * <p>
     * Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow an action on
     * a resource it is considered an implicit deny.
     * </p>
     * 
     * @return Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow an
     *         action on a resource it is considered an implicit deny.
     */
    public ImplicitDeny implicitDeny() {
        return implicitDeny;
    }

    /**
     * <p>
     * Information that explicitly denies the authorization.
     * </p>
     * 
     * @return Information that explicitly denies the authorization.
     */
    public ExplicitDeny explicitDeny() {
        return explicitDeny;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(implicitDeny());
        hashCode = 31 * hashCode + Objects.hashCode(explicitDeny());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Denied)) {
            return false;
        }
        Denied other = (Denied) obj;
        return Objects.equals(implicitDeny(), other.implicitDeny()) && Objects.equals(explicitDeny(), other.explicitDeny());
    }

    @Override
    public String toString() {
        return ToString.builder("Denied").add("ImplicitDeny", implicitDeny()).add("ExplicitDeny", explicitDeny()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "implicitDeny":
            return Optional.ofNullable(clazz.cast(implicitDeny()));
        case "explicitDeny":
            return Optional.ofNullable(clazz.cast(explicitDeny()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeniedMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Denied> {
        /**
         * <p>
         * Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow an
         * action on a resource it is considered an implicit deny.
         * </p>
         * 
         * @param implicitDeny
         *        Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow
         *        an action on a resource it is considered an implicit deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder implicitDeny(ImplicitDeny implicitDeny);

        /**
         * <p>
         * Information that implicitly denies the authorization. When a policy doesn't explicitly deny or allow an
         * action on a resource it is considered an implicit deny.
         * </p>
         * This is a convenience that creates an instance of the {@link ImplicitDeny.Builder} avoiding the need to
         * create one manually via {@link ImplicitDeny#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImplicitDeny.Builder#build()} is called immediately and its
         * result is passed to {@link #implicitDeny(ImplicitDeny)}.
         * 
         * @param implicitDeny
         *        a consumer that will call methods on {@link ImplicitDeny.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #implicitDeny(ImplicitDeny)
         */
        default Builder implicitDeny(Consumer<ImplicitDeny.Builder> implicitDeny) {
            return implicitDeny(ImplicitDeny.builder().applyMutation(implicitDeny).build());
        }

        /**
         * <p>
         * Information that explicitly denies the authorization.
         * </p>
         * 
         * @param explicitDeny
         *        Information that explicitly denies the authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitDeny(ExplicitDeny explicitDeny);

        /**
         * <p>
         * Information that explicitly denies the authorization.
         * </p>
         * This is a convenience that creates an instance of the {@link ExplicitDeny.Builder} avoiding the need to
         * create one manually via {@link ExplicitDeny#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExplicitDeny.Builder#build()} is called immediately and its
         * result is passed to {@link #explicitDeny(ExplicitDeny)}.
         * 
         * @param explicitDeny
         *        a consumer that will call methods on {@link ExplicitDeny.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explicitDeny(ExplicitDeny)
         */
        default Builder explicitDeny(Consumer<ExplicitDeny.Builder> explicitDeny) {
            return explicitDeny(ExplicitDeny.builder().applyMutation(explicitDeny).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImplicitDeny implicitDeny;

        private ExplicitDeny explicitDeny;

        private BuilderImpl() {
        }

        private BuilderImpl(Denied model) {
            implicitDeny(model.implicitDeny);
            explicitDeny(model.explicitDeny);
        }

        public final ImplicitDeny.Builder getImplicitDeny() {
            return implicitDeny != null ? implicitDeny.toBuilder() : null;
        }

        @Override
        public final Builder implicitDeny(ImplicitDeny implicitDeny) {
            this.implicitDeny = implicitDeny;
            return this;
        }

        public final void setImplicitDeny(ImplicitDeny.BuilderImpl implicitDeny) {
            this.implicitDeny = implicitDeny != null ? implicitDeny.build() : null;
        }

        public final ExplicitDeny.Builder getExplicitDeny() {
            return explicitDeny != null ? explicitDeny.toBuilder() : null;
        }

        @Override
        public final Builder explicitDeny(ExplicitDeny explicitDeny) {
            this.explicitDeny = explicitDeny;
            return this;
        }

        public final void setExplicitDeny(ExplicitDeny.BuilderImpl explicitDeny) {
            this.explicitDeny = explicitDeny != null ? explicitDeny.build() : null;
        }

        @Override
        public Denied build() {
            return new Denied(this);
        }
    }
}
