/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuthorizerResponse extends IotResponse implements
        ToCopyableBuilder<DescribeAuthorizerResponse.Builder, DescribeAuthorizerResponse> {
    private final AuthorizerDescription authorizerDescription;

    private DescribeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.authorizerDescription = builder.authorizerDescription;
    }

    /**
     * <p>
     * The authorizer description.
     * </p>
     * 
     * @return The authorizer description.
     */
    public AuthorizerDescription authorizerDescription() {
        return authorizerDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuthorizerResponse)) {
            return false;
        }
        DescribeAuthorizerResponse other = (DescribeAuthorizerResponse) obj;
        return Objects.equals(authorizerDescription(), other.authorizerDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAuthorizerResponse").add("AuthorizerDescription", authorizerDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerDescription":
            return Optional.ofNullable(clazz.cast(authorizerDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeAuthorizerResponse> {
        /**
         * <p>
         * The authorizer description.
         * </p>
         * 
         * @param authorizerDescription
         *        The authorizer description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerDescription(AuthorizerDescription authorizerDescription);

        /**
         * <p>
         * The authorizer description.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthorizerDescription.Builder} avoiding the need
         * to create one manually via {@link AuthorizerDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthorizerDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #authorizerDescription(AuthorizerDescription)}.
         * 
         * @param authorizerDescription
         *        a consumer that will call methods on {@link AuthorizerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerDescription(AuthorizerDescription)
         */
        default Builder authorizerDescription(Consumer<AuthorizerDescription.Builder> authorizerDescription) {
            return authorizerDescription(AuthorizerDescription.builder().applyMutation(authorizerDescription).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private AuthorizerDescription authorizerDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuthorizerResponse model) {
            super(model);
            authorizerDescription(model.authorizerDescription);
        }

        public final AuthorizerDescription.Builder getAuthorizerDescription() {
            return authorizerDescription != null ? authorizerDescription.toBuilder() : null;
        }

        @Override
        public final Builder authorizerDescription(AuthorizerDescription authorizerDescription) {
            this.authorizerDescription = authorizerDescription;
            return this;
        }

        public final void setAuthorizerDescription(AuthorizerDescription.BuilderImpl authorizerDescription) {
            this.authorizerDescription = authorizerDescription != null ? authorizerDescription.build() : null;
        }

        @Override
        public DescribeAuthorizerResponse build() {
            return new DescribeAuthorizerResponse(this);
        }
    }
}
