/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DescribeEndpoint operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointRequest extends IotRequest implements
        ToCopyableBuilder<DescribeEndpointRequest.Builder, DescribeEndpointRequest> {
    private final String endpointType;

    private DescribeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointType = builder.endpointType;
    }

    /**
     * <p>
     * The endpoint type (such as <code>iot:Data</code>, <code>iot:CredentialProvider</code> and <code>iot:Jobs</code>).
     * </p>
     * 
     * @return The endpoint type (such as <code>iot:Data</code>, <code>iot:CredentialProvider</code> and
     *         <code>iot:Jobs</code>).
     */
    public String endpointType() {
        return endpointType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointRequest)) {
            return false;
        }
        DescribeEndpointRequest other = (DescribeEndpointRequest) obj;
        return Objects.equals(endpointType(), other.endpointType());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEndpointRequest").add("EndpointType", endpointType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, DescribeEndpointRequest> {
        /**
         * <p>
         * The endpoint type (such as <code>iot:Data</code>, <code>iot:CredentialProvider</code> and
         * <code>iot:Jobs</code>).
         * </p>
         * 
         * @param endpointType
         *        The endpoint type (such as <code>iot:Data</code>, <code>iot:CredentialProvider</code> and
         *        <code>iot:Jobs</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String endpointType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointRequest model) {
            super(model);
            endpointType(model.endpointType);
        }

        public final String getEndpointType() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEndpointRequest build() {
            return new DescribeEndpointRequest(this);
        }
    }
}
