/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeEndpoint operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointResponse extends IotResponse implements
        ToCopyableBuilder<DescribeEndpointResponse.Builder, DescribeEndpointResponse> {
    private final String endpointAddress;

    private DescribeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAddress = builder.endpointAddress;
    }

    /**
     * <p>
     * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     * </p>
     * 
     * @return The endpoint. The format of the endpoint is as follows:
     *         <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     */
    public String endpointAddress() {
        return endpointAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse) obj;
        return Objects.equals(endpointAddress(), other.endpointAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEndpointResponse").add("EndpointAddress", endpointAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointAddress":
            return Optional.ofNullable(clazz.cast(endpointAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeEndpointResponse> {
        /**
         * <p>
         * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * </p>
         * 
         * @param endpointAddress
         *        The endpoint. The format of the endpoint is as follows:
         *        <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAddress(String endpointAddress);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String endpointAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            super(model);
            endpointAddress(model.endpointAddress);
        }

        public final String getEndpointAddress() {
            return endpointAddress;
        }

        @Override
        public final Builder endpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        public final void setEndpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }
    }
}
