/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobExecutionResponse extends IotResponse implements
        ToCopyableBuilder<DescribeJobExecutionResponse.Builder, DescribeJobExecutionResponse> {
    private final JobExecution execution;

    private DescribeJobExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.execution = builder.execution;
    }

    /**
     * <p>
     * Information about the job execution.
     * </p>
     * 
     * @return Information about the job execution.
     */
    public JobExecution execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobExecutionResponse)) {
            return false;
        }
        DescribeJobExecutionResponse other = (DescribeJobExecutionResponse) obj;
        return Objects.equals(execution(), other.execution());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobExecutionResponse").add("Execution", execution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "execution":
            return Optional.ofNullable(clazz.cast(execution()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeJobExecutionResponse> {
        /**
         * <p>
         * Information about the job execution.
         * </p>
         * 
         * @param execution
         *        Information about the job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(JobExecution execution);

        /**
         * <p>
         * Information about the job execution.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecution.Builder} avoiding the need to
         * create one manually via {@link JobExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #execution(JobExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link JobExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(JobExecution)
         */
        default Builder execution(Consumer<JobExecution.Builder> execution) {
            return execution(JobExecution.builder().applyMutation(execution).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private JobExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobExecutionResponse model) {
            super(model);
            execution(model.execution);
        }

        public final JobExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        @Override
        public final Builder execution(JobExecution execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(JobExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public DescribeJobExecutionResponse build() {
            return new DescribeJobExecutionResponse(this);
        }
    }
}
