/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRoleAliasRequest extends IotRequest implements
        ToCopyableBuilder<DescribeRoleAliasRequest.Builder, DescribeRoleAliasRequest> {
    private final String roleAlias;

    private DescribeRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
    }

    /**
     * <p>
     * The role alias to describe.
     * </p>
     * 
     * @return The role alias to describe.
     */
    public String roleAlias() {
        return roleAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRoleAliasRequest)) {
            return false;
        }
        DescribeRoleAliasRequest other = (DescribeRoleAliasRequest) obj;
        return Objects.equals(roleAlias(), other.roleAlias());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeRoleAliasRequest").add("RoleAlias", roleAlias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, DescribeRoleAliasRequest> {
        /**
         * <p>
         * The role alias to describe.
         * </p>
         * 
         * @param roleAlias
         *        The role alias to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String roleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRoleAliasRequest model) {
            super(model);
            roleAlias(model.roleAlias);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRoleAliasRequest build() {
            return new DescribeRoleAliasRequest(this);
        }
    }
}
