/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<DescribeThingGroupResponse.Builder, DescribeThingGroupResponse> {
    private final String thingGroupName;

    private final String thingGroupId;

    private final String thingGroupArn;

    private final Long version;

    private final ThingGroupProperties thingGroupProperties;

    private final ThingGroupMetadata thingGroupMetadata;

    private DescribeThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.thingGroupArn = builder.thingGroupArn;
        this.version = builder.version;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.thingGroupMetadata = builder.thingGroupMetadata;
    }

    /**
     * <p>
     * The name of the thing group.
     * </p>
     * 
     * @return The name of the thing group.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group ID.
     * </p>
     * 
     * @return The thing group ID.
     */
    public String thingGroupId() {
        return thingGroupId;
    }

    /**
     * <p>
     * The thing group ARN.
     * </p>
     * 
     * @return The thing group ARN.
     */
    public String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The version of the thing group.
     * </p>
     * 
     * @return The version of the thing group.
     */
    public Long version() {
        return version;
    }

    /**
     * <p>
     * The thing group properties.
     * </p>
     * 
     * @return The thing group properties.
     */
    public ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    /**
     * <p>
     * Thing group metadata.
     * </p>
     * 
     * @return Thing group metadata.
     */
    public ThingGroupMetadata thingGroupMetadata() {
        return thingGroupMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingGroupResponse)) {
            return false;
        }
        DescribeThingGroupResponse other = (DescribeThingGroupResponse) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupId(), other.thingGroupId())
                && Objects.equals(thingGroupArn(), other.thingGroupArn()) && Objects.equals(version(), other.version())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties())
                && Objects.equals(thingGroupMetadata(), other.thingGroupMetadata());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeThingGroupResponse").add("ThingGroupName", thingGroupName())
                .add("ThingGroupId", thingGroupId()).add("ThingGroupArn", thingGroupArn()).add("Version", version())
                .add("ThingGroupProperties", thingGroupProperties()).add("ThingGroupMetadata", thingGroupMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        case "thingGroupMetadata":
            return Optional.ofNullable(clazz.cast(thingGroupMetadata()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeThingGroupResponse> {
        /**
         * <p>
         * The name of the thing group.
         * </p>
         * 
         * @param thingGroupName
         *        The name of the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);

        /**
         * <p>
         * The thing group ARN.
         * </p>
         * 
         * @param thingGroupArn
         *        The thing group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The version of the thing group.
         * </p>
         * 
         * @param version
         *        The version of the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * 
         * @param thingGroupProperties
         *        The thing group properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupProperties.Builder} avoiding the need
         * to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        /**
         * <p>
         * Thing group metadata.
         * </p>
         * 
         * @param thingGroupMetadata
         *        Thing group metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupMetadata(ThingGroupMetadata thingGroupMetadata);

        /**
         * <p>
         * Thing group metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupMetadata.Builder} avoiding the need to
         * create one manually via {@link ThingGroupMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #thingGroupMetadata(ThingGroupMetadata)}.
         * 
         * @param thingGroupMetadata
         *        a consumer that will call methods on {@link ThingGroupMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupMetadata(ThingGroupMetadata)
         */
        default Builder thingGroupMetadata(Consumer<ThingGroupMetadata.Builder> thingGroupMetadata) {
            return thingGroupMetadata(ThingGroupMetadata.builder().applyMutation(thingGroupMetadata).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupId;

        private String thingGroupArn;

        private Long version;

        private ThingGroupProperties thingGroupProperties;

        private ThingGroupMetadata thingGroupMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingGroupResponse model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupId(model.thingGroupId);
            thingGroupArn(model.thingGroupArn);
            version(model.version);
            thingGroupProperties(model.thingGroupProperties);
            thingGroupMetadata(model.thingGroupMetadata);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final ThingGroupMetadata.Builder getThingGroupMetadata() {
            return thingGroupMetadata != null ? thingGroupMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupMetadata(ThingGroupMetadata thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata;
            return this;
        }

        public final void setThingGroupMetadata(ThingGroupMetadata.BuilderImpl thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata != null ? thingGroupMetadata.build() : null;
        }

        @Override
        public DescribeThingGroupResponse build() {
            return new DescribeThingGroupResponse(this);
        }
    }
}
