/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThingRegistrationTaskResponse extends IotResponse implements
        ToCopyableBuilder<DescribeThingRegistrationTaskResponse.Builder, DescribeThingRegistrationTaskResponse> {
    private final String taskId;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final String templateBody;

    private final String inputFileBucket;

    private final String inputFileKey;

    private final String roleArn;

    private final String status;

    private final String message;

    private final Integer successCount;

    private final Integer failureCount;

    private final Integer percentageProgress;

    private DescribeThingRegistrationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.templateBody = builder.templateBody;
        this.inputFileBucket = builder.inputFileBucket;
        this.inputFileKey = builder.inputFileKey;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.message = builder.message;
        this.successCount = builder.successCount;
        this.failureCount = builder.failureCount;
        this.percentageProgress = builder.percentageProgress;
    }

    /**
     * <p>
     * The task ID.
     * </p>
     * 
     * @return The task ID.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The task creation date.
     * </p>
     * 
     * @return The task creation date.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the task was last modified.
     * </p>
     * 
     * @return The date when the task was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The task's template.
     * </p>
     * 
     * @return The task's template.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The S3 bucket that contains the input file.
     * </p>
     * 
     * @return The S3 bucket that contains the input file.
     */
    public String inputFileBucket() {
        return inputFileBucket;
    }

    /**
     * <p>
     * The input file key.
     * </p>
     * 
     * @return The input file key.
     */
    public String inputFileKey() {
        return inputFileKey;
    }

    /**
     * <p>
     * The role ARN that grants access to the input file bucket.
     * </p>
     * 
     * @return The role ARN that grants access to the input file bucket.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the bulk thing provisioning task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the bulk thing provisioning task.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the bulk thing provisioning task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the bulk thing provisioning task.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The message.
     * </p>
     * 
     * @return The message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The number of things successfully provisioned.
     * </p>
     * 
     * @return The number of things successfully provisioned.
     */
    public Integer successCount() {
        return successCount;
    }

    /**
     * <p>
     * The number of things that failed to be provisioned.
     * </p>
     * 
     * @return The number of things that failed to be provisioned.
     */
    public Integer failureCount() {
        return failureCount;
    }

    /**
     * <p>
     * The progress of the bulk provisioning task expressed as a percentage.
     * </p>
     * 
     * @return The progress of the bulk provisioning task expressed as a percentage.
     */
    public Integer percentageProgress() {
        return percentageProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(inputFileBucket());
        hashCode = 31 * hashCode + Objects.hashCode(inputFileKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(successCount());
        hashCode = 31 * hashCode + Objects.hashCode(failureCount());
        hashCode = 31 * hashCode + Objects.hashCode(percentageProgress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingRegistrationTaskResponse)) {
            return false;
        }
        DescribeThingRegistrationTaskResponse other = (DescribeThingRegistrationTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(inputFileBucket(), other.inputFileBucket())
                && Objects.equals(inputFileKey(), other.inputFileKey()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(successCount(), other.successCount()) && Objects.equals(failureCount(), other.failureCount())
                && Objects.equals(percentageProgress(), other.percentageProgress());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeThingRegistrationTaskResponse").add("TaskId", taskId())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate())
                .add("TemplateBody", templateBody()).add("InputFileBucket", inputFileBucket())
                .add("InputFileKey", inputFileKey()).add("RoleArn", roleArn()).add("Status", statusAsString())
                .add("Message", message()).add("SuccessCount", successCount()).add("FailureCount", failureCount())
                .add("PercentageProgress", percentageProgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "inputFileBucket":
            return Optional.ofNullable(clazz.cast(inputFileBucket()));
        case "inputFileKey":
            return Optional.ofNullable(clazz.cast(inputFileKey()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "successCount":
            return Optional.ofNullable(clazz.cast(successCount()));
        case "failureCount":
            return Optional.ofNullable(clazz.cast(failureCount()));
        case "percentageProgress":
            return Optional.ofNullable(clazz.cast(percentageProgress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, DescribeThingRegistrationTaskResponse> {
        /**
         * <p>
         * The task ID.
         * </p>
         * 
         * @param taskId
         *        The task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The task creation date.
         * </p>
         * 
         * @param creationDate
         *        The task creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the task was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the task was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The task's template.
         * </p>
         * 
         * @param templateBody
         *        The task's template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The S3 bucket that contains the input file.
         * </p>
         * 
         * @param inputFileBucket
         *        The S3 bucket that contains the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileBucket(String inputFileBucket);

        /**
         * <p>
         * The input file key.
         * </p>
         * 
         * @param inputFileKey
         *        The input file key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileKey(String inputFileKey);

        /**
         * <p>
         * The role ARN that grants access to the input file bucket.
         * </p>
         * 
         * @param roleArn
         *        The role ARN that grants access to the input file bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the bulk thing provisioning task.
         * </p>
         * 
         * @param status
         *        The status of the bulk thing provisioning task.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the bulk thing provisioning task.
         * </p>
         * 
         * @param status
         *        The status of the bulk thing provisioning task.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The message.
         * </p>
         * 
         * @param message
         *        The message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The number of things successfully provisioned.
         * </p>
         * 
         * @param successCount
         *        The number of things successfully provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successCount(Integer successCount);

        /**
         * <p>
         * The number of things that failed to be provisioned.
         * </p>
         * 
         * @param failureCount
         *        The number of things that failed to be provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCount(Integer failureCount);

        /**
         * <p>
         * The progress of the bulk provisioning task expressed as a percentage.
         * </p>
         * 
         * @param percentageProgress
         *        The progress of the bulk provisioning task expressed as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageProgress(Integer percentageProgress);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String taskId;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private String templateBody;

        private String inputFileBucket;

        private String inputFileKey;

        private String roleArn;

        private String status;

        private String message;

        private Integer successCount;

        private Integer failureCount;

        private Integer percentageProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingRegistrationTaskResponse model) {
            super(model);
            taskId(model.taskId);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            templateBody(model.templateBody);
            inputFileBucket(model.inputFileBucket);
            inputFileKey(model.inputFileKey);
            roleArn(model.roleArn);
            status(model.status);
            message(model.message);
            successCount(model.successCount);
            failureCount(model.failureCount);
            percentageProgress(model.percentageProgress);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getInputFileBucket() {
            return inputFileBucket;
        }

        @Override
        public final Builder inputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
            return this;
        }

        public final void setInputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
        }

        public final String getInputFileKey() {
            return inputFileKey;
        }

        @Override
        public final Builder inputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
            return this;
        }

        public final void setInputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getSuccessCount() {
            return successCount;
        }

        @Override
        public final Builder successCount(Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public final void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        public final Integer getFailureCount() {
            return failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        public final Integer getPercentageProgress() {
            return percentageProgress;
        }

        @Override
        public final Builder percentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
            return this;
        }

        public final void setPercentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
        }

        @Override
        public DescribeThingRegistrationTaskResponse build() {
            return new DescribeThingRegistrationTaskResponse(this);
        }
    }
}
