/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.FileLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the OTA update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileLocation implements StructuredPojo, ToCopyableBuilder<FileLocation.Builder, FileLocation> {
    private final Stream stream;

    private final S3Location s3Location;

    private FileLocation(BuilderImpl builder) {
        this.stream = builder.stream;
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The stream that contains the OTA update.
     * </p>
     * 
     * @return The stream that contains the OTA update.
     */
    public Stream stream() {
        return stream;
    }

    /**
     * <p>
     * The location of the updated firmware in S3.
     * </p>
     * 
     * @return The location of the updated firmware in S3.
     */
    public S3Location s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stream());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileLocation)) {
            return false;
        }
        FileLocation other = (FileLocation) obj;
        return Objects.equals(stream(), other.stream()) && Objects.equals(s3Location(), other.s3Location());
    }

    @Override
    public String toString() {
        return ToString.builder("FileLocation").add("Stream", stream()).add("S3Location", s3Location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stream":
            return Optional.ofNullable(clazz.cast(stream()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FileLocation> {
        /**
         * <p>
         * The stream that contains the OTA update.
         * </p>
         * 
         * @param stream
         *        The stream that contains the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stream(Stream stream);

        /**
         * <p>
         * The stream that contains the OTA update.
         * </p>
         * This is a convenience that creates an instance of the {@link Stream.Builder} avoiding the need to create one
         * manually via {@link Stream#builder()}.
         *
         * When the {@link Consumer} completes, {@link Stream.Builder#build()} is called immediately and its result is
         * passed to {@link #stream(Stream)}.
         * 
         * @param stream
         *        a consumer that will call methods on {@link Stream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stream(Stream)
         */
        default Builder stream(Consumer<Stream.Builder> stream) {
            return stream(Stream.builder().applyMutation(stream).build());
        }

        /**
         * <p>
         * The location of the updated firmware in S3.
         * </p>
         * 
         * @param s3Location
         *        The location of the updated firmware in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * The location of the updated firmware in S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3Location)
         */
        default Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return s3Location(S3Location.builder().applyMutation(s3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Stream stream;

        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(FileLocation model) {
            stream(model.stream);
            s3Location(model.s3Location);
        }

        public final Stream.Builder getStream() {
            return stream != null ? stream.toBuilder() : null;
        }

        @Override
        public final Builder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        public final void setStream(Stream.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        public final S3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public FileLocation build() {
            return new FileLocation(this);
        }
    }
}
