/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobDocumentResponse extends IotResponse implements
        ToCopyableBuilder<GetJobDocumentResponse.Builder, GetJobDocumentResponse> {
    private final String document;

    private GetJobDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
    }

    /**
     * <p>
     * The job document content.
     * </p>
     * 
     * @return The job document content.
     */
    public String document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobDocumentResponse)) {
            return false;
        }
        GetJobDocumentResponse other = (GetJobDocumentResponse) obj;
        return Objects.equals(document(), other.document());
    }

    @Override
    public String toString() {
        return ToString.builder("GetJobDocumentResponse").add("Document", document()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, GetJobDocumentResponse> {
        /**
         * <p>
         * The job document content.
         * </p>
         * 
         * @param document
         *        The job document content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobDocumentResponse model) {
            super(model);
            document(model.document);
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public GetJobDocumentResponse build() {
            return new GetJobDocumentResponse(this);
        }
    }
}
