/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOtaUpdateResponse extends IotResponse implements
        ToCopyableBuilder<GetOtaUpdateResponse.Builder, GetOtaUpdateResponse> {
    private final OTAUpdateInfo otaUpdateInfo;

    private GetOtaUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdateInfo = builder.otaUpdateInfo;
    }

    /**
     * <p>
     * The OTA update info.
     * </p>
     * 
     * @return The OTA update info.
     */
    public OTAUpdateInfo otaUpdateInfo() {
        return otaUpdateInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOtaUpdateResponse)) {
            return false;
        }
        GetOtaUpdateResponse other = (GetOtaUpdateResponse) obj;
        return Objects.equals(otaUpdateInfo(), other.otaUpdateInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOtaUpdateResponse").add("OtaUpdateInfo", otaUpdateInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateInfo":
            return Optional.ofNullable(clazz.cast(otaUpdateInfo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, GetOtaUpdateResponse> {
        /**
         * <p>
         * The OTA update info.
         * </p>
         * 
         * @param otaUpdateInfo
         *        The OTA update info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateInfo(OTAUpdateInfo otaUpdateInfo);

        /**
         * <p>
         * The OTA update info.
         * </p>
         * This is a convenience that creates an instance of the {@link OTAUpdateInfo.Builder} avoiding the need to
         * create one manually via {@link OTAUpdateInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link OTAUpdateInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #otaUpdateInfo(OTAUpdateInfo)}.
         * 
         * @param otaUpdateInfo
         *        a consumer that will call methods on {@link OTAUpdateInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaUpdateInfo(OTAUpdateInfo)
         */
        default Builder otaUpdateInfo(Consumer<OTAUpdateInfo.Builder> otaUpdateInfo) {
            return otaUpdateInfo(OTAUpdateInfo.builder().applyMutation(otaUpdateInfo).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private OTAUpdateInfo otaUpdateInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOtaUpdateResponse model) {
            super(model);
            otaUpdateInfo(model.otaUpdateInfo);
        }

        public final OTAUpdateInfo.Builder getOtaUpdateInfo() {
            return otaUpdateInfo != null ? otaUpdateInfo.toBuilder() : null;
        }

        @Override
        public final Builder otaUpdateInfo(OTAUpdateInfo otaUpdateInfo) {
            this.otaUpdateInfo = otaUpdateInfo;
            return this;
        }

        public final void setOtaUpdateInfo(OTAUpdateInfo.BuilderImpl otaUpdateInfo) {
            this.otaUpdateInfo = otaUpdateInfo != null ? otaUpdateInfo.build() : null;
        }

        @Override
        public GetOtaUpdateResponse build() {
            return new GetOtaUpdateResponse(this);
        }
    }
}
