/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.transform.JobExecutionStatusDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the job execution status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionStatusDetails implements StructuredPojo,
        ToCopyableBuilder<JobExecutionStatusDetails.Builder, JobExecutionStatusDetails> {
    private final Map<String, String> detailsMap;

    private JobExecutionStatusDetails(BuilderImpl builder) {
        this.detailsMap = builder.detailsMap;
    }

    /**
     * <p>
     * The job execution status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The job execution status.
     */
    public Map<String, String> detailsMap() {
        return detailsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailsMap());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionStatusDetails)) {
            return false;
        }
        JobExecutionStatusDetails other = (JobExecutionStatusDetails) obj;
        return Objects.equals(detailsMap(), other.detailsMap());
    }

    @Override
    public String toString() {
        return ToString.builder("JobExecutionStatusDetails").add("DetailsMap", detailsMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detailsMap":
            return Optional.ofNullable(clazz.cast(detailsMap()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionStatusDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobExecutionStatusDetails> {
        /**
         * <p>
         * The job execution status.
         * </p>
         * 
         * @param detailsMap
         *        The job execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailsMap(Map<String, String> detailsMap);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> detailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionStatusDetails model) {
            detailsMap(model.detailsMap);
        }

        public final Map<String, String> getDetailsMap() {
            return detailsMap;
        }

        @Override
        public final Builder detailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
            return this;
        }

        public final void setDetailsMap(Map<String, String> detailsMap) {
            this.detailsMap = DetailsMapCopier.copy(detailsMap);
        }

        @Override
        public JobExecutionStatusDetails build() {
            return new JobExecutionStatusDetails(this);
        }
    }
}
