/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.JobExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job execution summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSummary implements StructuredPojo,
        ToCopyableBuilder<JobExecutionSummary.Builder, JobExecutionSummary> {
    private final String status;

    private final Instant queuedAt;

    private final Instant startedAt;

    private final Instant lastUpdatedAt;

    private final Long executionNumber;

    private JobExecutionSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
    }

    /**
     * <p>
     * The status of the job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution.
     * @see JobExecutionStatus
     */
    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution.
     * @see JobExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was queued.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was queued.
     */
    public Instant queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution started.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was last updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
     * particular device. It can be used later in commands which return or update job execution information.
     * </p>
     * 
     * @return A string (consisting of the digits "0" through "9") which identifies this particular job execution on
     *         this particular device. It can be used later in commands which return or update job execution
     *         information.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(queuedAt(), other.queuedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(executionNumber(), other.executionNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("JobExecutionSummary").add("Status", statusAsString()).add("QueuedAt", queuedAt())
                .add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt()).add("ExecutionNumber", executionNumber())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "queuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobExecutionSummary> {
        /**
         * <p>
         * The status of the job execution.
         * </p>
         * 
         * @param status
         *        The status of the job execution.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job execution.
         * </p>
         * 
         * @param status
         *        The status of the job execution.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was queued.
         * </p>
         * 
         * @param queuedAt
         *        The time, in milliseconds since the epoch, when the job execution was queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Instant queuedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution started.
         * </p>
         * 
         * @param startedAt
         *        The time, in milliseconds since the epoch, when the job execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the job execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
         * particular device. It can be used later in commands which return or update job execution information.
         * </p>
         * 
         * @param executionNumber
         *        A string (consisting of the digits "0" through "9") which identifies this particular job execution on
         *        this particular device. It can be used later in commands which return or update job execution
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant queuedAt;

        private Instant startedAt;

        private Instant lastUpdatedAt;

        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            status(model.status);
            queuedAt(model.queuedAt);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            executionNumber(model.executionNumber);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getQueuedAt() {
            return queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }
    }
}
