/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.JobExecutionsRolloutConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to create a staged rollout of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionsRolloutConfig implements StructuredPojo,
        ToCopyableBuilder<JobExecutionsRolloutConfig.Builder, JobExecutionsRolloutConfig> {
    private final Integer maximumPerMinute;

    private JobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
    }

    /**
     * <p>
     * The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to
     * create a staged rollout.
     * </p>
     * 
     * @return The maximum number of things that will be notified of a pending job, per minute. This parameter allows
     *         you to create a staged rollout.
     */
    public Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionsRolloutConfig)) {
            return false;
        }
        JobExecutionsRolloutConfig other = (JobExecutionsRolloutConfig) obj;
        return Objects.equals(maximumPerMinute(), other.maximumPerMinute());
    }

    @Override
    public String toString() {
        return ToString.builder("JobExecutionsRolloutConfig").add("MaximumPerMinute", maximumPerMinute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionsRolloutConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobExecutionsRolloutConfig> {
        /**
         * <p>
         * The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to
         * create a staged rollout.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of things that will be notified of a pending job, per minute. This parameter allows
         *        you to create a staged rollout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionsRolloutConfig model) {
            maximumPerMinute(model.maximumPerMinute);
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public JobExecutionsRolloutConfig build() {
            return new JobExecutionsRolloutConfig(this);
        }
    }
}
