/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActiveViolationsResponse extends IotResponse implements
        ToCopyableBuilder<ListActiveViolationsResponse.Builder, ListActiveViolationsResponse> {
    private final List<ActiveViolation> activeViolations;

    private final String nextToken;

    private ListActiveViolationsResponse(BuilderImpl builder) {
        super(builder);
        this.activeViolations = builder.activeViolations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of active violations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of active violations.
     */
    public List<ActiveViolation> activeViolations() {
        return activeViolations;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeViolations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActiveViolationsResponse)) {
            return false;
        }
        ListActiveViolationsResponse other = (ListActiveViolationsResponse) obj;
        return Objects.equals(activeViolations(), other.activeViolations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListActiveViolationsResponse").add("ActiveViolations", activeViolations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeViolations":
            return Optional.ofNullable(clazz.cast(activeViolations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListActiveViolationsResponse> {
        /**
         * <p>
         * The list of active violations.
         * </p>
         * 
         * @param activeViolations
         *        The list of active violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeViolations(Collection<ActiveViolation> activeViolations);

        /**
         * <p>
         * The list of active violations.
         * </p>
         * 
         * @param activeViolations
         *        The list of active violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeViolations(ActiveViolation... activeViolations);

        /**
         * <p>
         * The list of active violations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActiveViolation>.Builder} avoiding the need
         * to create one manually via {@link List<ActiveViolation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveViolation>.Builder#build()} is called immediately and
         * its result is passed to {@link #activeViolations(List<ActiveViolation>)}.
         * 
         * @param activeViolations
         *        a consumer that will call methods on {@link List<ActiveViolation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeViolations(List<ActiveViolation>)
         */
        Builder activeViolations(Consumer<ActiveViolation.Builder>... activeViolations);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ActiveViolation> activeViolations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActiveViolationsResponse model) {
            super(model);
            activeViolations(model.activeViolations);
            nextToken(model.nextToken);
        }

        public final Collection<ActiveViolation.Builder> getActiveViolations() {
            return activeViolations != null ? activeViolations.stream().map(ActiveViolation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeViolations(Collection<ActiveViolation> activeViolations) {
            this.activeViolations = ActiveViolationsCopier.copy(activeViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeViolations(ActiveViolation... activeViolations) {
            activeViolations(Arrays.asList(activeViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeViolations(Consumer<ActiveViolation.Builder>... activeViolations) {
            activeViolations(Stream.of(activeViolations).map(c -> ActiveViolation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActiveViolations(Collection<ActiveViolation.BuilderImpl> activeViolations) {
            this.activeViolations = ActiveViolationsCopier.copyFromBuilder(activeViolations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActiveViolationsResponse build() {
            return new ListActiveViolationsResponse(this);
        }
    }
}
