/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditFindingsRequest extends IotRequest implements
        ToCopyableBuilder<ListAuditFindingsRequest.Builder, ListAuditFindingsRequest> {
    private final String taskId;

    private final String checkName;

    private final ResourceIdentifier resourceIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startTime;

    private final Instant endTime;

    private ListAuditFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime
     * and endTime, but not both.
     * </p>
     * 
     * @return A filter to limit results to the audit with the specified ID. You must specify either the taskId or the
     *         startTime and endTime, but not both.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * A filter to limit results to the findings for the specified audit check.
     * </p>
     * 
     * @return A filter to limit results to the findings for the specified audit check.
     */
    public String checkName() {
        return checkName;
    }

    /**
     * <p>
     * Information identifying the non-compliant resource.
     * </p>
     * 
     * @return Information identifying the non-compliant resource.
     */
    public ResourceIdentifier resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter to limit results to those found after the specified time. You must specify either the startTime and
     * endTime or the taskId, but not both.
     * </p>
     * 
     * @return A filter to limit results to those found after the specified time. You must specify either the startTime
     *         and endTime or the taskId, but not both.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A filter to limit results to those found before the specified time. You must specify either the startTime and
     * endTime or the taskId, but not both.
     * </p>
     * 
     * @return A filter to limit results to those found before the specified time. You must specify either the startTime
     *         and endTime or the taskId, but not both.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(checkName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsRequest)) {
            return false;
        }
        ListAuditFindingsRequest other = (ListAuditFindingsRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(checkName(), other.checkName())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAuditFindingsRequest").add("TaskId", taskId()).add("CheckName", checkName())
                .add("ResourceIdentifier", resourceIdentifier()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "checkName":
            return Optional.ofNullable(clazz.cast(checkName()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, ListAuditFindingsRequest> {
        /**
         * <p>
         * A filter to limit results to the audit with the specified ID. You must specify either the taskId or the
         * startTime and endTime, but not both.
         * </p>
         * 
         * @param taskId
         *        A filter to limit results to the audit with the specified ID. You must specify either the taskId or
         *        the startTime and endTime, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * A filter to limit results to the findings for the specified audit check.
         * </p>
         * 
         * @param checkName
         *        A filter to limit results to the findings for the specified audit check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkName(String checkName);

        /**
         * <p>
         * Information identifying the non-compliant resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        Information identifying the non-compliant resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(ResourceIdentifier resourceIdentifier);

        /**
         * <p>
         * Information identifying the non-compliant resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceIdentifier.Builder} avoiding the need to
         * create one manually via {@link ResourceIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceIdentifier(ResourceIdentifier)}.
         * 
         * @param resourceIdentifier
         *        a consumer that will call methods on {@link ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifier(ResourceIdentifier)
         */
        default Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return resourceIdentifier(ResourceIdentifier.builder().applyMutation(resourceIdentifier).build());
        }

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter to limit results to those found after the specified time. You must specify either the startTime and
         * endTime or the taskId, but not both.
         * </p>
         * 
         * @param startTime
         *        A filter to limit results to those found after the specified time. You must specify either the
         *        startTime and endTime or the taskId, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A filter to limit results to those found before the specified time. You must specify either the startTime and
         * endTime or the taskId, but not both.
         * </p>
         * 
         * @param endTime
         *        A filter to limit results to those found before the specified time. You must specify either the
         *        startTime and endTime or the taskId, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private String checkName;

        private ResourceIdentifier resourceIdentifier;

        private Integer maxResults;

        private String nextToken;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsRequest model) {
            super(model);
            taskId(model.taskId);
            checkName(model.checkName);
            resourceIdentifier(model.resourceIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getCheckName() {
            return checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return resourceIdentifier != null ? resourceIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditFindingsRequest build() {
            return new ListAuditFindingsRequest(this);
        }
    }
}
