/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobExecutionsForJobResponse extends IotResponse implements
        ToCopyableBuilder<ListJobExecutionsForJobResponse.Builder, ListJobExecutionsForJobResponse> {
    private final List<JobExecutionSummaryForJob> executionSummaries;

    private final String nextToken;

    private ListJobExecutionsForJobResponse(BuilderImpl builder) {
        super(builder);
        this.executionSummaries = builder.executionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of job execution summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job execution summaries.
     */
    public List<JobExecutionSummaryForJob> executionSummaries() {
        return executionSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobExecutionsForJobResponse)) {
            return false;
        }
        ListJobExecutionsForJobResponse other = (ListJobExecutionsForJobResponse) obj;
        return Objects.equals(executionSummaries(), other.executionSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListJobExecutionsForJobResponse").add("ExecutionSummaries", executionSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionSummaries":
            return Optional.ofNullable(clazz.cast(executionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListJobExecutionsForJobResponse> {
        /**
         * <p>
         * A list of job execution summaries.
         * </p>
         * 
         * @param executionSummaries
         *        A list of job execution summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummaries(Collection<JobExecutionSummaryForJob> executionSummaries);

        /**
         * <p>
         * A list of job execution summaries.
         * </p>
         * 
         * @param executionSummaries
         *        A list of job execution summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummaries(JobExecutionSummaryForJob... executionSummaries);

        /**
         * <p>
         * A list of job execution summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobExecutionSummaryForJob>.Builder}
         * avoiding the need to create one manually via {@link List<JobExecutionSummaryForJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobExecutionSummaryForJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #executionSummaries(List<JobExecutionSummaryForJob>)}.
         * 
         * @param executionSummaries
         *        a consumer that will call methods on {@link List<JobExecutionSummaryForJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSummaries(List<JobExecutionSummaryForJob>)
         */
        Builder executionSummaries(Consumer<JobExecutionSummaryForJob.Builder>... executionSummaries);

        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<JobExecutionSummaryForJob> executionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobExecutionsForJobResponse model) {
            super(model);
            executionSummaries(model.executionSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<JobExecutionSummaryForJob.Builder> getExecutionSummaries() {
            return executionSummaries != null ? executionSummaries.stream().map(JobExecutionSummaryForJob::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executionSummaries(Collection<JobExecutionSummaryForJob> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForJobListCopier.copy(executionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(JobExecutionSummaryForJob... executionSummaries) {
            executionSummaries(Arrays.asList(executionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(Consumer<JobExecutionSummaryForJob.Builder>... executionSummaries) {
            executionSummaries(Stream.of(executionSummaries)
                    .map(c -> JobExecutionSummaryForJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExecutionSummaries(Collection<JobExecutionSummaryForJob.BuilderImpl> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForJobListCopier.copyFromBuilder(executionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobExecutionsForJobResponse build() {
            return new ListJobExecutionsForJobResponse(this);
        }
    }
}
