/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOtaUpdatesRequest extends IotRequest implements
        ToCopyableBuilder<ListOtaUpdatesRequest.Builder, ListOtaUpdatesRequest> {
    private final Integer maxResults;

    private final String nextToken;

    private final String otaUpdateStatus;

    private ListOtaUpdatesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.otaUpdateStatus = builder.otaUpdateStatus;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token used to retrieve the next set of results.
     * </p>
     * 
     * @return A token used to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The OTA update job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update job status.
     * @see OTAUpdateStatus
     */
    public OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(otaUpdateStatus);
    }

    /**
     * <p>
     * The OTA update job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update job status.
     * @see OTAUpdateStatus
     */
    public String otaUpdateStatusAsString() {
        return otaUpdateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOtaUpdatesRequest)) {
            return false;
        }
        ListOtaUpdatesRequest other = (ListOtaUpdatesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(otaUpdateStatusAsString(), other.otaUpdateStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOtaUpdatesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OtaUpdateStatus", otaUpdateStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "otaUpdateStatus":
            return Optional.ofNullable(clazz.cast(otaUpdateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, ListOtaUpdatesRequest> {
        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token used to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token used to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The OTA update job status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update job status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(String otaUpdateStatus);

        /**
         * <p>
         * The OTA update job status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update job status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String otaUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOtaUpdatesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            otaUpdateStatus(model.otaUpdateStatus);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOtaUpdateStatus() {
            return otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus.toString());
            return this;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOtaUpdatesRequest build() {
            return new ListOtaUpdatesRequest(this);
        }
    }
}
