/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScheduledAuditsResponse extends IotResponse implements
        ToCopyableBuilder<ListScheduledAuditsResponse.Builder, ListScheduledAuditsResponse> {
    private final List<ScheduledAuditMetadata> scheduledAudits;

    private final String nextToken;

    private ListScheduledAuditsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAudits = builder.scheduledAudits;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of scheduled audits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of scheduled audits.
     */
    public List<ScheduledAuditMetadata> scheduledAudits() {
        return scheduledAudits;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAudits());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledAuditsResponse)) {
            return false;
        }
        ListScheduledAuditsResponse other = (ListScheduledAuditsResponse) obj;
        return Objects.equals(scheduledAudits(), other.scheduledAudits()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListScheduledAuditsResponse").add("ScheduledAudits", scheduledAudits())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAudits":
            return Optional.ofNullable(clazz.cast(scheduledAudits()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListScheduledAuditsResponse> {
        /**
         * <p>
         * The list of scheduled audits.
         * </p>
         * 
         * @param scheduledAudits
         *        The list of scheduled audits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAudits(Collection<ScheduledAuditMetadata> scheduledAudits);

        /**
         * <p>
         * The list of scheduled audits.
         * </p>
         * 
         * @param scheduledAudits
         *        The list of scheduled audits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAudits(ScheduledAuditMetadata... scheduledAudits);

        /**
         * <p>
         * The list of scheduled audits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledAuditMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<ScheduledAuditMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledAuditMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledAudits(List<ScheduledAuditMetadata>)}.
         * 
         * @param scheduledAudits
         *        a consumer that will call methods on {@link List<ScheduledAuditMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledAudits(List<ScheduledAuditMetadata>)
         */
        Builder scheduledAudits(Consumer<ScheduledAuditMetadata.Builder>... scheduledAudits);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ScheduledAuditMetadata> scheduledAudits = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledAuditsResponse model) {
            super(model);
            scheduledAudits(model.scheduledAudits);
            nextToken(model.nextToken);
        }

        public final Collection<ScheduledAuditMetadata.Builder> getScheduledAudits() {
            return scheduledAudits != null ? scheduledAudits.stream().map(ScheduledAuditMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledAudits(Collection<ScheduledAuditMetadata> scheduledAudits) {
            this.scheduledAudits = ScheduledAuditMetadataListCopier.copy(scheduledAudits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledAudits(ScheduledAuditMetadata... scheduledAudits) {
            scheduledAudits(Arrays.asList(scheduledAudits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledAudits(Consumer<ScheduledAuditMetadata.Builder>... scheduledAudits) {
            scheduledAudits(Stream.of(scheduledAudits).map(c -> ScheduledAuditMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledAudits(Collection<ScheduledAuditMetadata.BuilderImpl> scheduledAudits) {
            this.scheduledAudits = ScheduledAuditMetadataListCopier.copyFromBuilder(scheduledAudits);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListScheduledAuditsResponse build() {
            return new ListScheduledAuditsResponse(this);
        }
    }
}
