/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesForTargetRequest extends IotRequest implements
        ToCopyableBuilder<ListSecurityProfilesForTargetRequest.Builder, ListSecurityProfilesForTargetRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final Boolean recursive;

    private final String securityProfileTargetArn;

    private ListSecurityProfilesForTargetRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
        this.securityProfileTargetArn = builder.securityProfileTargetArn;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If true, return child groups as well.
     * </p>
     * 
     * @return If true, return child groups as well.
     */
    public Boolean recursive() {
        return recursive;
    }

    /**
     * <p>
     * The ARN of the target (thing group) whose attached security profiles you want to get.
     * </p>
     * 
     * @return The ARN of the target (thing group) whose attached security profiles you want to get.
     */
    public String securityProfileTargetArn() {
        return securityProfileTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileTargetArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetRequest)) {
            return false;
        }
        ListSecurityProfilesForTargetRequest other = (ListSecurityProfilesForTargetRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(recursive(), other.recursive())
                && Objects.equals(securityProfileTargetArn(), other.securityProfileTargetArn());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSecurityProfilesForTargetRequest").add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Recursive", recursive())
                .add("SecurityProfileTargetArn", securityProfileTargetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        case "securityProfileTargetArn":
            return Optional.ofNullable(clazz.cast(securityProfileTargetArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, ListSecurityProfilesForTargetRequest> {
        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If true, return child groups as well.
         * </p>
         * 
         * @param recursive
         *        If true, return child groups as well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        /**
         * <p>
         * The ARN of the target (thing group) whose attached security profiles you want to get.
         * </p>
         * 
         * @param securityProfileTargetArn
         *        The ARN of the target (thing group) whose attached security profiles you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargetArn(String securityProfileTargetArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Boolean recursive;

        private String securityProfileTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            recursive(model.recursive);
            securityProfileTargetArn(model.securityProfileTargetArn);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public final String getSecurityProfileTargetArn() {
            return securityProfileTargetArn;
        }

        @Override
        public final Builder securityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
            return this;
        }

        public final void setSecurityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecurityProfilesForTargetRequest build() {
            return new ListSecurityProfilesForTargetRequest(this);
        }
    }
}
