/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsForPolicyResponse extends IotResponse implements
        ToCopyableBuilder<ListTargetsForPolicyResponse.Builder, ListTargetsForPolicyResponse> {
    private final List<String> targets;

    private final String nextMarker;

    private ListTargetsForPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The policy targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The policy targets.
     */
    public List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * A marker used to get the next set of results.
     * </p>
     * 
     * @return A marker used to get the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResponse)) {
            return false;
        }
        ListTargetsForPolicyResponse other = (ListTargetsForPolicyResponse) obj;
        return Objects.equals(targets(), other.targets()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTargetsForPolicyResponse").add("Targets", targets()).add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListTargetsForPolicyResponse> {
        /**
         * <p>
         * The policy targets.
         * </p>
         * 
         * @param targets
         *        The policy targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The policy targets.
         * </p>
         * 
         * @param targets
         *        The policy targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * A marker used to get the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        A marker used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForPolicyResponse model) {
            super(model);
            targets(model.targets);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListTargetsForPolicyResponse build() {
            return new ListTargetsForPolicyResponse(this);
        }
    }
}
