/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsForSecurityProfileResponse extends IotResponse implements
        ToCopyableBuilder<ListTargetsForSecurityProfileResponse.Builder, ListTargetsForSecurityProfileResponse> {
    private final List<SecurityProfileTarget> securityProfileTargets;

    private final String nextToken;

    private ListTargetsForSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileTargets = builder.securityProfileTargets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The thing groups to which the security profile is attached.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The thing groups to which the security profile is attached.
     */
    public List<SecurityProfileTarget> securityProfileTargets() {
        return securityProfileTargets;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileTargets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForSecurityProfileResponse)) {
            return false;
        }
        ListTargetsForSecurityProfileResponse other = (ListTargetsForSecurityProfileResponse) obj;
        return Objects.equals(securityProfileTargets(), other.securityProfileTargets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTargetsForSecurityProfileResponse").add("SecurityProfileTargets", securityProfileTargets())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileTargets":
            return Optional.ofNullable(clazz.cast(securityProfileTargets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListTargetsForSecurityProfileResponse> {
        /**
         * <p>
         * The thing groups to which the security profile is attached.
         * </p>
         * 
         * @param securityProfileTargets
         *        The thing groups to which the security profile is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargets(Collection<SecurityProfileTarget> securityProfileTargets);

        /**
         * <p>
         * The thing groups to which the security profile is attached.
         * </p>
         * 
         * @param securityProfileTargets
         *        The thing groups to which the security profile is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargets(SecurityProfileTarget... securityProfileTargets);

        /**
         * <p>
         * The thing groups to which the security profile is attached.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityProfileTarget>.Builder} avoiding
         * the need to create one manually via {@link List<SecurityProfileTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityProfileTarget>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityProfileTargets(List<SecurityProfileTarget>)}.
         * 
         * @param securityProfileTargets
         *        a consumer that will call methods on {@link List<SecurityProfileTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileTargets(List<SecurityProfileTarget>)
         */
        Builder securityProfileTargets(Consumer<SecurityProfileTarget.Builder>... securityProfileTargets);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<SecurityProfileTarget> securityProfileTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForSecurityProfileResponse model) {
            super(model);
            securityProfileTargets(model.securityProfileTargets);
            nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileTarget.Builder> getSecurityProfileTargets() {
            return securityProfileTargets != null ? securityProfileTargets.stream().map(SecurityProfileTarget::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileTargets(Collection<SecurityProfileTarget> securityProfileTargets) {
            this.securityProfileTargets = SecurityProfileTargetsCopier.copy(securityProfileTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargets(SecurityProfileTarget... securityProfileTargets) {
            securityProfileTargets(Arrays.asList(securityProfileTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargets(Consumer<SecurityProfileTarget.Builder>... securityProfileTargets) {
            securityProfileTargets(Stream.of(securityProfileTargets)
                    .map(c -> SecurityProfileTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileTargets(Collection<SecurityProfileTarget.BuilderImpl> securityProfileTargets) {
            this.securityProfileTargets = SecurityProfileTargetsCopier.copyFromBuilder(securityProfileTargets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTargetsForSecurityProfileResponse build() {
            return new ListTargetsForSecurityProfileResponse(this);
        }
    }
}
