/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingGroupsForThingResponse extends IotResponse implements
        ToCopyableBuilder<ListThingGroupsForThingResponse.Builder, ListThingGroupsForThingResponse> {
    private final List<GroupNameAndArn> thingGroups;

    private final String nextToken;

    private ListThingGroupsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroups = builder.thingGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The thing groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The thing groups.
     */
    public List<GroupNameAndArn> thingGroups() {
        return thingGroups;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsForThingResponse)) {
            return false;
        }
        ListThingGroupsForThingResponse other = (ListThingGroupsForThingResponse) obj;
        return Objects.equals(thingGroups(), other.thingGroups()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListThingGroupsForThingResponse").add("ThingGroups", thingGroups())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroups":
            return Optional.ofNullable(clazz.cast(thingGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListThingGroupsForThingResponse> {
        /**
         * <p>
         * The thing groups.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(Collection<GroupNameAndArn> thingGroups);

        /**
         * <p>
         * The thing groups.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(GroupNameAndArn... thingGroups);

        /**
         * <p>
         * The thing groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupNameAndArn>.Builder} avoiding the need
         * to create one manually via {@link List<GroupNameAndArn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupNameAndArn>.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroups(List<GroupNameAndArn>)}.
         * 
         * @param thingGroups
         *        a consumer that will call methods on {@link List<GroupNameAndArn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroups(List<GroupNameAndArn>)
         */
        Builder thingGroups(Consumer<GroupNameAndArn.Builder>... thingGroups);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<GroupNameAndArn> thingGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsForThingResponse model) {
            super(model);
            thingGroups(model.thingGroups);
            nextToken(model.nextToken);
        }

        public final Collection<GroupNameAndArn.Builder> getThingGroups() {
            return thingGroups != null ? thingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder thingGroups(Collection<GroupNameAndArn> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(GroupNameAndArn... thingGroups) {
            thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<GroupNameAndArn.Builder>... thingGroups) {
            thingGroups(Stream.of(thingGroups).map(c -> GroupNameAndArn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setThingGroups(Collection<GroupNameAndArn.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(thingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingGroupsForThingResponse build() {
            return new ListThingGroupsForThingResponse(this);
        }
    }
}
