/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingGroupsRequest extends IotRequest implements
        ToCopyableBuilder<ListThingGroupsRequest.Builder, ListThingGroupsRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final String parentGroup;

    private final String namePrefixFilter;

    private final Boolean recursive;

    private ListThingGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.parentGroup = builder.parentGroup;
        this.namePrefixFilter = builder.namePrefixFilter;
        this.recursive = builder.recursive;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter that limits the results to those with the specified parent group.
     * </p>
     * 
     * @return A filter that limits the results to those with the specified parent group.
     */
    public String parentGroup() {
        return parentGroup;
    }

    /**
     * <p>
     * A filter that limits the results to those with the specified name prefix.
     * </p>
     * 
     * @return A filter that limits the results to those with the specified name prefix.
     */
    public String namePrefixFilter() {
        return namePrefixFilter;
    }

    /**
     * <p>
     * If true, return child groups as well.
     * </p>
     * 
     * @return If true, return child groups as well.
     */
    public Boolean recursive() {
        return recursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(parentGroup());
        hashCode = 31 * hashCode + Objects.hashCode(namePrefixFilter());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsRequest)) {
            return false;
        }
        ListThingGroupsRequest other = (ListThingGroupsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(parentGroup(), other.parentGroup())
                && Objects.equals(namePrefixFilter(), other.namePrefixFilter()) && Objects.equals(recursive(), other.recursive());
    }

    @Override
    public String toString() {
        return ToString.builder("ListThingGroupsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ParentGroup", parentGroup()).add("NamePrefixFilter", namePrefixFilter()).add("Recursive", recursive())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "parentGroup":
            return Optional.ofNullable(clazz.cast(parentGroup()));
        case "namePrefixFilter":
            return Optional.ofNullable(clazz.cast(namePrefixFilter()));
        case "recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, ListThingGroupsRequest> {
        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter that limits the results to those with the specified parent group.
         * </p>
         * 
         * @param parentGroup
         *        A filter that limits the results to those with the specified parent group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroup(String parentGroup);

        /**
         * <p>
         * A filter that limits the results to those with the specified name prefix.
         * </p>
         * 
         * @param namePrefixFilter
         *        A filter that limits the results to those with the specified name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefixFilter(String namePrefixFilter);

        /**
         * <p>
         * If true, return child groups as well.
         * </p>
         * 
         * @param recursive
         *        If true, return child groups as well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String parentGroup;

        private String namePrefixFilter;

        private Boolean recursive;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            parentGroup(model.parentGroup);
            namePrefixFilter(model.namePrefixFilter);
            recursive(model.recursive);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getParentGroup() {
            return parentGroup;
        }

        @Override
        public final Builder parentGroup(String parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        public final void setParentGroup(String parentGroup) {
            this.parentGroup = parentGroup;
        }

        public final String getNamePrefixFilter() {
            return namePrefixFilter;
        }

        @Override
        public final Builder namePrefixFilter(String namePrefixFilter) {
            this.namePrefixFilter = namePrefixFilter;
            return this;
        }

        public final void setNamePrefixFilter(String namePrefixFilter) {
            this.namePrefixFilter = namePrefixFilter;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingGroupsRequest build() {
            return new ListThingGroupsRequest(this);
        }
    }
}
