/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingRegistrationTasksResponse extends IotResponse implements
        ToCopyableBuilder<ListThingRegistrationTasksResponse.Builder, ListThingRegistrationTasksResponse> {
    private final List<String> taskIds;

    private final String nextToken;

    private ListThingRegistrationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.taskIds = builder.taskIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of bulk thing provisioning task IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of bulk thing provisioning task IDs.
     */
    public List<String> taskIds() {
        return taskIds;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTasksResponse)) {
            return false;
        }
        ListThingRegistrationTasksResponse other = (ListThingRegistrationTasksResponse) obj;
        return Objects.equals(taskIds(), other.taskIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListThingRegistrationTasksResponse").add("TaskIds", taskIds()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskIds":
            return Optional.ofNullable(clazz.cast(taskIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListThingRegistrationTasksResponse> {
        /**
         * <p>
         * A list of bulk thing provisioning task IDs.
         * </p>
         * 
         * @param taskIds
         *        A list of bulk thing provisioning task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(Collection<String> taskIds);

        /**
         * <p>
         * A list of bulk thing provisioning task IDs.
         * </p>
         * 
         * @param taskIds
         *        A list of bulk thing provisioning task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(String... taskIds);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> taskIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTasksResponse model) {
            super(model);
            taskIds(model.taskIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTaskIds() {
            return taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String... taskIds) {
            taskIds(Arrays.asList(taskIds));
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdListCopier.copy(taskIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingRegistrationTasksResponse build() {
            return new ListThingRegistrationTasksResponse(this);
        }
    }
}
