/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListV2LoggingLevelsRequest extends IotRequest implements
        ToCopyableBuilder<ListV2LoggingLevelsRequest.Builder, ListV2LoggingLevelsRequest> {
    private final String targetType;

    private final String nextToken;

    private final Integer maxResults;

    private ListV2LoggingLevelsRequest(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * @see LogTargetType
     */
    public LogTargetType targetType() {
        return LogTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
     * @see LogTargetType
     */
    public String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListV2LoggingLevelsRequest)) {
            return false;
        }
        ListV2LoggingLevelsRequest other = (ListV2LoggingLevelsRequest) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListV2LoggingLevelsRequest").add("TargetType", targetTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, ListV2LoggingLevelsRequest> {
        /**
         * <p>
         * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * </p>
         * 
         * @param targetType
         *        The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * </p>
         * 
         * @param targetType
         *        The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(LogTargetType targetType);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String targetType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListV2LoggingLevelsRequest model) {
            super(model);
            targetType(model.targetType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(LogTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListV2LoggingLevelsRequest build() {
            return new ListV2LoggingLevelsRequest(this);
        }
    }
}
