/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListV2LoggingLevelsResponse extends IotResponse implements
        ToCopyableBuilder<ListV2LoggingLevelsResponse.Builder, ListV2LoggingLevelsResponse> {
    private final List<LogTargetConfiguration> logTargetConfigurations;

    private final String nextToken;

    private ListV2LoggingLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.logTargetConfigurations = builder.logTargetConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The logging configuration for a target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The logging configuration for a target.
     */
    public List<LogTargetConfiguration> logTargetConfigurations() {
        return logTargetConfigurations;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTargetConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListV2LoggingLevelsResponse)) {
            return false;
        }
        ListV2LoggingLevelsResponse other = (ListV2LoggingLevelsResponse) obj;
        return Objects.equals(logTargetConfigurations(), other.logTargetConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListV2LoggingLevelsResponse").add("LogTargetConfigurations", logTargetConfigurations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logTargetConfigurations":
            return Optional.ofNullable(clazz.cast(logTargetConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListV2LoggingLevelsResponse> {
        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogTargetConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<LogTargetConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogTargetConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #logTargetConfigurations(List<LogTargetConfiguration>)}.
         * 
         * @param logTargetConfigurations
         *        a consumer that will call methods on {@link List<LogTargetConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logTargetConfigurations(List<LogTargetConfiguration>)
         */
        Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<LogTargetConfiguration> logTargetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListV2LoggingLevelsResponse model) {
            super(model);
            logTargetConfigurations(model.logTargetConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<LogTargetConfiguration.Builder> getLogTargetConfigurations() {
            return logTargetConfigurations != null ? logTargetConfigurations.stream().map(LogTargetConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copy(logTargetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations) {
            logTargetConfigurations(Arrays.asList(logTargetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations) {
            logTargetConfigurations(Stream.of(logTargetConfigurations)
                    .map(c -> LogTargetConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogTargetConfigurations(Collection<LogTargetConfiguration.BuilderImpl> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copyFromBuilder(logTargetConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListV2LoggingLevelsResponse build() {
            return new ListV2LoggingLevelsResponse(this);
        }
    }
}
