/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListViolationEventsResponse extends IotResponse implements
        ToCopyableBuilder<ListViolationEventsResponse.Builder, ListViolationEventsResponse> {
    private final List<ViolationEvent> violationEvents;

    private final String nextToken;

    private ListViolationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.violationEvents = builder.violationEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The security profile violation alerts issued for this account during the given time frame, potentially filtered
     * by security profile, behavior violated, or thing (device) violating.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security profile violation alerts issued for this account during the given time frame, potentially
     *         filtered by security profile, behavior violated, or thing (device) violating.
     */
    public List<ViolationEvent> violationEvents() {
        return violationEvents;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationEvents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViolationEventsResponse)) {
            return false;
        }
        ListViolationEventsResponse other = (ListViolationEventsResponse) obj;
        return Objects.equals(violationEvents(), other.violationEvents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListViolationEventsResponse").add("ViolationEvents", violationEvents())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationEvents":
            return Optional.ofNullable(clazz.cast(violationEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, ListViolationEventsResponse> {
        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time frame, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * 
         * @param violationEvents
         *        The security profile violation alerts issued for this account during the given time frame, potentially
         *        filtered by security profile, behavior violated, or thing (device) violating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEvents(Collection<ViolationEvent> violationEvents);

        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time frame, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * 
         * @param violationEvents
         *        The security profile violation alerts issued for this account during the given time frame, potentially
         *        filtered by security profile, behavior violated, or thing (device) violating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEvents(ViolationEvent... violationEvents);

        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time frame, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ViolationEvent>.Builder} avoiding the need
         * to create one manually via {@link List<ViolationEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ViolationEvent>.Builder#build()} is called immediately and
         * its result is passed to {@link #violationEvents(List<ViolationEvent>)}.
         * 
         * @param violationEvents
         *        a consumer that will call methods on {@link List<ViolationEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEvents(List<ViolationEvent>)
         */
        Builder violationEvents(Consumer<ViolationEvent.Builder>... violationEvents);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ViolationEvent> violationEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListViolationEventsResponse model) {
            super(model);
            violationEvents(model.violationEvents);
            nextToken(model.nextToken);
        }

        public final Collection<ViolationEvent.Builder> getViolationEvents() {
            return violationEvents != null ? violationEvents.stream().map(ViolationEvent::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder violationEvents(Collection<ViolationEvent> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copy(violationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(ViolationEvent... violationEvents) {
            violationEvents(Arrays.asList(violationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(Consumer<ViolationEvent.Builder>... violationEvents) {
            violationEvents(Stream.of(violationEvents).map(c -> ViolationEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setViolationEvents(Collection<ViolationEvent.BuilderImpl> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copyFromBuilder(violationEvents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListViolationEventsResponse build() {
            return new ListViolationEventsResponse(this);
        }
    }
}
