/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.LogTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A log target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogTarget implements StructuredPojo, ToCopyableBuilder<LogTarget.Builder, LogTarget> {
    private final String targetType;

    private final String targetName;

    private LogTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type.
     * @see LogTargetType
     */
    public LogTargetType targetType() {
        return LogTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link LogTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type.
     * @see LogTargetType
     */
    public String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The target name.
     * </p>
     * 
     * @return The target name.
     */
    public String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogTarget)) {
            return false;
        }
        LogTarget other = (LogTarget) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetName(), other.targetName());
    }

    @Override
    public String toString() {
        return ToString.builder("LogTarget").add("TargetType", targetTypeAsString()).add("TargetName", targetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LogTarget> {
        /**
         * <p>
         * The target type.
         * </p>
         * 
         * @param targetType
         *        The target type.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type.
         * </p>
         * 
         * @param targetType
         *        The target type.
         * @see LogTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogTargetType
         */
        Builder targetType(LogTargetType targetType);

        /**
         * <p>
         * The target name.
         * </p>
         * 
         * @param targetName
         *        The target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);
    }

    static final class BuilderImpl implements Builder {
        private String targetType;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogTarget model) {
            targetType(model.targetType);
            targetName(model.targetName);
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(LogTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetName() {
            return targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public LogTarget build() {
            return new LogTarget(this);
        }
    }
}
