/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.OTAUpdateSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An OTA update summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OTAUpdateSummary implements StructuredPojo, ToCopyableBuilder<OTAUpdateSummary.Builder, OTAUpdateSummary> {
    private final String otaUpdateId;

    private final String otaUpdateArn;

    private final Instant creationDate;

    private OTAUpdateSummary(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The OTA update ID.
     * </p>
     * 
     * @return The OTA update ID.
     */
    public String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The OTA update ARN.
     * </p>
     * 
     * @return The OTA update ARN.
     */
    public String otaUpdateArn() {
        return otaUpdateArn;
    }

    /**
     * <p>
     * The date when the OTA update was created.
     * </p>
     * 
     * @return The date when the OTA update was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateSummary)) {
            return false;
        }
        OTAUpdateSummary other = (OTAUpdateSummary) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(otaUpdateArn(), other.otaUpdateArn())
                && Objects.equals(creationDate(), other.creationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("OTAUpdateSummary").add("OtaUpdateId", otaUpdateId()).add("OtaUpdateArn", otaUpdateArn())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "otaUpdateArn":
            return Optional.ofNullable(clazz.cast(otaUpdateArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OTAUpdateSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OTAUpdateSummary> {
        /**
         * <p>
         * The OTA update ID.
         * </p>
         * 
         * @param otaUpdateId
         *        The OTA update ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The OTA update ARN.
         * </p>
         * 
         * @param otaUpdateArn
         *        The OTA update ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateArn(String otaUpdateArn);

        /**
         * <p>
         * The date when the OTA update was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the OTA update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String otaUpdateId;

        private String otaUpdateArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateSummary model) {
            otaUpdateId(model.otaUpdateId);
            otaUpdateArn(model.otaUpdateArn);
            creationDate(model.creationDate);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getOtaUpdateArn() {
            return otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public OTAUpdateSummary build() {
            return new OTAUpdateSummary(this);
        }
    }
}
