/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PresignedUrlConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for pre-signed S3 URLs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PresignedUrlConfig implements StructuredPojo,
        ToCopyableBuilder<PresignedUrlConfig.Builder, PresignedUrlConfig> {
    private final String roleArn;

    private final Long expiresInSec;

    private PresignedUrlConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.expiresInSec = builder.expiresInSec;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
     * data/updates are stored. The role must also grant permission for IoT to download the files.
     * </p>
     * 
     * @return The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
     *         data/updates are stored. The role must also grant permission for IoT to download the files.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600 seconds.
     * Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
     * </p>
     * 
     * @return How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
     *         seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
     */
    public Long expiresInSec() {
        return expiresInSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSec());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresignedUrlConfig)) {
            return false;
        }
        PresignedUrlConfig other = (PresignedUrlConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(expiresInSec(), other.expiresInSec());
    }

    @Override
    public String toString() {
        return ToString.builder("PresignedUrlConfig").add("RoleArn", roleArn()).add("ExpiresInSec", expiresInSec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "expiresInSec":
            return Optional.ofNullable(clazz.cast(expiresInSec()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PresignedUrlConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PresignedUrlConfig> {
        /**
         * <p>
         * The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
         * data/updates are stored. The role must also grant permission for IoT to download the files.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the
         *        job data/updates are stored. The role must also grant permission for IoT to download the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
         * seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
         * </p>
         * 
         * @param expiresInSec
         *        How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
         *        seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSec(Long expiresInSec);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private Long expiresInSec;

        private BuilderImpl() {
        }

        private BuilderImpl(PresignedUrlConfig model) {
            roleArn(model.roleArn);
            expiresInSec(model.expiresInSec);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Long getExpiresInSec() {
            return expiresInSec;
        }

        @Override
        public final Builder expiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
            return this;
        }

        public final void setExpiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
        }

        @Override
        public PresignedUrlConfig build() {
            return new PresignedUrlConfig(this);
        }
    }
}
