/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterThingResponse extends IotResponse implements
        ToCopyableBuilder<RegisterThingResponse.Builder, RegisterThingResponse> {
    private final String certificatePem;

    private final Map<String, String> resourceArns;

    private RegisterThingResponse(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.resourceArns = builder.resourceArns;
    }

    /**
     * <p>
     * .
     * </p>
     * 
     * @return .
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * ARNs for the generated resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return ARNs for the generated resources.
     */
    public Map<String, String> resourceArns() {
        return resourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterThingResponse)) {
            return false;
        }
        RegisterThingResponse other = (RegisterThingResponse) obj;
        return Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(resourceArns(), other.resourceArns());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterThingResponse").add("CertificatePem", certificatePem())
                .add("ResourceArns", resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, RegisterThingResponse> {
        /**
         * <p>
         * .
         * </p>
         * 
         * @param certificatePem
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * ARNs for the generated resources.
         * </p>
         * 
         * @param resourceArns
         *        ARNs for the generated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Map<String, String> resourceArns);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String certificatePem;

        private Map<String, String> resourceArns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterThingResponse model) {
            super(model);
            certificatePem(model.certificatePem);
            resourceArns(model.resourceArns);
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final Map<String, String> getResourceArns() {
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        public final void setResourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public RegisterThingResponse build() {
            return new RegisterThingResponse(this);
        }
    }
}
