/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ResourceIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information identifying the non-compliant resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdentifier implements StructuredPojo,
        ToCopyableBuilder<ResourceIdentifier.Builder, ResourceIdentifier> {
    private final String deviceCertificateId;

    private final String caCertificateId;

    private final String cognitoIdentityPoolId;

    private final String clientId;

    private final PolicyVersionIdentifier policyVersionIdentifier;

    private final String account;

    private ResourceIdentifier(BuilderImpl builder) {
        this.deviceCertificateId = builder.deviceCertificateId;
        this.caCertificateId = builder.caCertificateId;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.clientId = builder.clientId;
        this.policyVersionIdentifier = builder.policyVersionIdentifier;
        this.account = builder.account;
    }

    /**
     * <p>
     * The ID of the certificate attached to the resource.
     * </p>
     * 
     * @return The ID of the certificate attached to the resource.
     */
    public String deviceCertificateId() {
        return deviceCertificateId;
    }

    /**
     * <p>
     * The ID of the CA certificate used to authorize the certificate.
     * </p>
     * 
     * @return The ID of the CA certificate used to authorize the certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The ID of the Cognito Identity Pool.
     * </p>
     * 
     * @return The ID of the Cognito Identity Pool.
     */
    public String cognitoIdentityPoolId() {
        return cognitoIdentityPoolId;
    }

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @return The client ID.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The version of the policy associated with the resource.
     * </p>
     * 
     * @return The version of the policy associated with the resource.
     */
    public PolicyVersionIdentifier policyVersionIdentifier() {
        return policyVersionIdentifier;
    }

    /**
     * <p>
     * The account with which the resource is associated.
     * </p>
     * 
     * @return The account with which the resource is associated.
     */
    public String account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier) obj;
        return Objects.equals(deviceCertificateId(), other.deviceCertificateId())
                && Objects.equals(caCertificateId(), other.caCertificateId())
                && Objects.equals(cognitoIdentityPoolId(), other.cognitoIdentityPoolId())
                && Objects.equals(clientId(), other.clientId())
                && Objects.equals(policyVersionIdentifier(), other.policyVersionIdentifier())
                && Objects.equals(account(), other.account());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceIdentifier").add("DeviceCertificateId", deviceCertificateId())
                .add("CaCertificateId", caCertificateId()).add("CognitoIdentityPoolId", cognitoIdentityPoolId())
                .add("ClientId", clientId()).add("PolicyVersionIdentifier", policyVersionIdentifier()).add("Account", account())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceCertificateId":
            return Optional.ofNullable(clazz.cast(deviceCertificateId()));
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "cognitoIdentityPoolId":
            return Optional.ofNullable(clazz.cast(cognitoIdentityPoolId()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "policyVersionIdentifier":
            return Optional.ofNullable(clazz.cast(policyVersionIdentifier()));
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceIdentifier> {
        /**
         * <p>
         * The ID of the certificate attached to the resource.
         * </p>
         * 
         * @param deviceCertificateId
         *        The ID of the certificate attached to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificateId(String deviceCertificateId);

        /**
         * <p>
         * The ID of the CA certificate used to authorize the certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The ID of the CA certificate used to authorize the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The ID of the Cognito Identity Pool.
         * </p>
         * 
         * @param cognitoIdentityPoolId
         *        The ID of the Cognito Identity Pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityPoolId(String cognitoIdentityPoolId);

        /**
         * <p>
         * The client ID.
         * </p>
         * 
         * @param clientId
         *        The client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * 
         * @param policyVersionIdentifier
         *        The version of the policy associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyVersionIdentifier.Builder} avoiding the
         * need to create one manually via {@link PolicyVersionIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyVersionIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #policyVersionIdentifier(PolicyVersionIdentifier)}.
         * 
         * @param policyVersionIdentifier
         *        a consumer that will call methods on {@link PolicyVersionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersionIdentifier(PolicyVersionIdentifier)
         */
        default Builder policyVersionIdentifier(Consumer<PolicyVersionIdentifier.Builder> policyVersionIdentifier) {
            return policyVersionIdentifier(PolicyVersionIdentifier.builder().applyMutation(policyVersionIdentifier).build());
        }

        /**
         * <p>
         * The account with which the resource is associated.
         * </p>
         * 
         * @param account
         *        The account with which the resource is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);
    }

    static final class BuilderImpl implements Builder {
        private String deviceCertificateId;

        private String caCertificateId;

        private String cognitoIdentityPoolId;

        private String clientId;

        private PolicyVersionIdentifier policyVersionIdentifier;

        private String account;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            deviceCertificateId(model.deviceCertificateId);
            caCertificateId(model.caCertificateId);
            cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            clientId(model.clientId);
            policyVersionIdentifier(model.policyVersionIdentifier);
            account(model.account);
        }

        public final String getDeviceCertificateId() {
            return deviceCertificateId;
        }

        @Override
        public final Builder deviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
            return this;
        }

        public final void setDeviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getCognitoIdentityPoolId() {
            return cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final PolicyVersionIdentifier.Builder getPolicyVersionIdentifier() {
            return policyVersionIdentifier != null ? policyVersionIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier;
            return this;
        }

        public final void setPolicyVersionIdentifier(PolicyVersionIdentifier.BuilderImpl policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier != null ? policyVersionIdentifier.build() : null;
        }

        public final String getAccount() {
            return account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }
    }
}
