/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.RoleAliasDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Role alias description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleAliasDescription implements StructuredPojo,
        ToCopyableBuilder<RoleAliasDescription.Builder, RoleAliasDescription> {
    private final String roleAlias;

    private final String roleAliasArn;

    private final String roleArn;

    private final String owner;

    private final Integer credentialDurationSeconds;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private RoleAliasDescription(BuilderImpl builder) {
        this.roleAlias = builder.roleAlias;
        this.roleAliasArn = builder.roleAliasArn;
        this.roleArn = builder.roleArn;
        this.owner = builder.owner;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The role alias.
     * </p>
     * 
     * @return The role alias.
     */
    public String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The ARN of the role alias.
     * </p>
     * 
     * @return The ARN of the role alias.
     */
    public String roleAliasArn() {
        return roleAliasArn;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The role alias owner.
     * </p>
     * 
     * @return The role alias owner.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The number of seconds for which the credential is valid.
     * </p>
     * 
     * @return The number of seconds for which the credential is valid.
     */
    public Integer credentialDurationSeconds() {
        return credentialDurationSeconds;
    }

    /**
     * <p>
     * The UNIX timestamp of when the role alias was created.
     * </p>
     * 
     * @return The UNIX timestamp of when the role alias was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The UNIX timestamp of when the role alias was last modified.
     * </p>
     * 
     * @return The UNIX timestamp of when the role alias was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(credentialDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleAliasDescription)) {
            return false;
        }
        RoleAliasDescription other = (RoleAliasDescription) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleAliasArn(), other.roleAliasArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(owner(), other.owner())
                && Objects.equals(credentialDurationSeconds(), other.credentialDurationSeconds())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("RoleAliasDescription").add("RoleAlias", roleAlias()).add("RoleAliasArn", roleAliasArn())
                .add("RoleArn", roleArn()).add("Owner", owner()).add("CredentialDurationSeconds", credentialDurationSeconds())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "credentialDurationSeconds":
            return Optional.ofNullable(clazz.cast(credentialDurationSeconds()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoleAliasDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RoleAliasDescription> {
        /**
         * <p>
         * The role alias.
         * </p>
         * 
         * @param roleAlias
         *        The role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The ARN of the role alias.
         * </p>
         * 
         * @param roleAliasArn
         *        The ARN of the role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleArn
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The role alias owner.
         * </p>
         * 
         * @param owner
         *        The role alias owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The number of seconds for which the credential is valid.
         * </p>
         * 
         * @param credentialDurationSeconds
         *        The number of seconds for which the credential is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialDurationSeconds(Integer credentialDurationSeconds);

        /**
         * <p>
         * The UNIX timestamp of when the role alias was created.
         * </p>
         * 
         * @param creationDate
         *        The UNIX timestamp of when the role alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The UNIX timestamp of when the role alias was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The UNIX timestamp of when the role alias was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String roleAlias;

        private String roleAliasArn;

        private String roleArn;

        private String owner;

        private Integer credentialDurationSeconds;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleAliasDescription model) {
            roleAlias(model.roleAlias);
            roleAliasArn(model.roleAliasArn);
            roleArn(model.roleArn);
            owner(model.owner);
            credentialDurationSeconds(model.credentialDurationSeconds);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Integer getCredentialDurationSeconds() {
            return credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public RoleAliasDescription build() {
            return new RoleAliasDescription(this);
        }
    }
}
