/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchIndexRequest extends IotRequest implements
        ToCopyableBuilder<SearchIndexRequest.Builder, SearchIndexRequest> {
    private final String indexName;

    private final String queryString;

    private final String nextToken;

    private final Integer maxResults;

    private final String queryVersion;

    private SearchIndexRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.queryVersion = builder.queryVersion;
    }

    /**
     * <p>
     * The search index name.
     * </p>
     * 
     * @return The search index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The search query string.
     * </p>
     * 
     * @return The search query string.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The query version.
     * </p>
     * 
     * @return The query version.
     */
    public String queryVersion() {
        return queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexRequest)) {
            return false;
        }
        SearchIndexRequest other = (SearchIndexRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(queryVersion(), other.queryVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchIndexRequest").add("IndexName", indexName()).add("QueryString", queryString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("QueryVersion", queryVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, SearchIndexRequest> {
        /**
         * <p>
         * The search index name.
         * </p>
         * 
         * @param indexName
         *        The search index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The search query string.
         * </p>
         * 
         * @param queryString
         *        The search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The query version.
         * </p>
         * 
         * @param queryVersion
         *        The query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String indexName;

        private String queryString;

        private String nextToken;

        private Integer maxResults;

        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchIndexRequest model) {
            super(model);
            indexName(model.indexName);
            queryString(model.queryString);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            queryVersion(model.queryVersion);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchIndexRequest build() {
            return new SearchIndexRequest(this);
        }
    }
}
