/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchIndexResponse extends IotResponse implements
        ToCopyableBuilder<SearchIndexResponse.Builder, SearchIndexResponse> {
    private final String nextToken;

    private final List<ThingDocument> things;

    private final List<ThingGroupDocument> thingGroups;

    private SearchIndexResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.things = builder.things;
        this.thingGroups = builder.thingGroups;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The things that match the search query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The things that match the search query.
     */
    public List<ThingDocument> things() {
        return things;
    }

    /**
     * <p>
     * The thing groups that match the search query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The thing groups that match the search query.
     */
    public List<ThingGroupDocument> thingGroups() {
        return thingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(things());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexResponse)) {
            return false;
        }
        SearchIndexResponse other = (SearchIndexResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(things(), other.things())
                && Objects.equals(thingGroups(), other.thingGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchIndexResponse").add("NextToken", nextToken()).add("Things", things())
                .add("ThingGroups", thingGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "things":
            return Optional.ofNullable(clazz.cast(things()));
        case "thingGroups":
            return Optional.ofNullable(clazz.cast(thingGroups()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotResponse.Builder, CopyableBuilder<Builder, SearchIndexResponse> {
        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * 
         * @param things
         *        The things that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<ThingDocument> things);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * 
         * @param things
         *        The things that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(ThingDocument... things);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThingDocument>.Builder} avoiding the need
         * to create one manually via {@link List<ThingDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThingDocument>.Builder#build()} is called immediately and
         * its result is passed to {@link #things(List<ThingDocument>)}.
         * 
         * @param things
         *        a consumer that will call methods on {@link List<ThingDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #things(List<ThingDocument>)
         */
        Builder things(Consumer<ThingDocument.Builder>... things);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(Collection<ThingGroupDocument> thingGroups);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(ThingGroupDocument... thingGroups);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThingGroupDocument>.Builder} avoiding the
         * need to create one manually via {@link List<ThingGroupDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThingGroupDocument>.Builder#build()} is called immediately
         * and its result is passed to {@link #thingGroups(List<ThingGroupDocument>)}.
         * 
         * @param thingGroups
         *        a consumer that will call methods on {@link List<ThingGroupDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroups(List<ThingGroupDocument>)
         */
        Builder thingGroups(Consumer<ThingGroupDocument.Builder>... thingGroups);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ThingDocument> things = DefaultSdkAutoConstructList.getInstance();

        private List<ThingGroupDocument> thingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchIndexResponse model) {
            super(model);
            nextToken(model.nextToken);
            things(model.things);
            thingGroups(model.thingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ThingDocument.Builder> getThings() {
            return things != null ? things.stream().map(ThingDocument::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<ThingDocument> things) {
            this.things = ThingDocumentListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingDocument... things) {
            things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<ThingDocument.Builder>... things) {
            things(Stream.of(things).map(c -> ThingDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThings(Collection<ThingDocument.BuilderImpl> things) {
            this.things = ThingDocumentListCopier.copyFromBuilder(things);
        }

        public final Collection<ThingGroupDocument.Builder> getThingGroups() {
            return thingGroups != null ? thingGroups.stream().map(ThingGroupDocument::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder thingGroups(Collection<ThingGroupDocument> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(ThingGroupDocument... thingGroups) {
            thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<ThingGroupDocument.Builder>... thingGroups) {
            thingGroups(Stream.of(thingGroups).map(c -> ThingGroupDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setThingGroups(Collection<ThingGroupDocument.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copyFromBuilder(thingGroups);
        }

        @Override
        public SearchIndexResponse build() {
            return new SearchIndexResponse(this);
        }
    }
}
