/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SecurityProfileIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information for a Device Defender security profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityProfileIdentifier implements StructuredPojo,
        ToCopyableBuilder<SecurityProfileIdentifier.Builder, SecurityProfileIdentifier> {
    private final String name;

    private final String arn;

    private SecurityProfileIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name you have given to the security profile.
     * </p>
     * 
     * @return The name you have given to the security profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the security profile.
     * </p>
     * 
     * @return The ARN of the security profile.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileIdentifier)) {
            return false;
        }
        SecurityProfileIdentifier other = (SecurityProfileIdentifier) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn());
    }

    @Override
    public String toString() {
        return ToString.builder("SecurityProfileIdentifier").add("Name", name()).add("Arn", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityProfileIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityProfileIdentifier> {
        /**
         * <p>
         * The name you have given to the security profile.
         * </p>
         * 
         * @param name
         *        The name you have given to the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the security profile.
         * </p>
         * 
         * @param arn
         *        The ARN of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileIdentifier model) {
            name(model.name);
            arn(model.arn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public SecurityProfileIdentifier build() {
            return new SecurityProfileIdentifier(this);
        }
    }
}
