/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SecurityProfileTargetMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a security profile and the target associated with it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityProfileTargetMapping implements StructuredPojo,
        ToCopyableBuilder<SecurityProfileTargetMapping.Builder, SecurityProfileTargetMapping> {
    private final SecurityProfileIdentifier securityProfileIdentifier;

    private final SecurityProfileTarget target;

    private SecurityProfileTargetMapping(BuilderImpl builder) {
        this.securityProfileIdentifier = builder.securityProfileIdentifier;
        this.target = builder.target;
    }

    /**
     * <p>
     * Information that identifies the security profile.
     * </p>
     * 
     * @return Information that identifies the security profile.
     */
    public SecurityProfileIdentifier securityProfileIdentifier() {
        return securityProfileIdentifier;
    }

    /**
     * <p>
     * Information about the target (thing group) associated with the security profile.
     * </p>
     * 
     * @return Information about the target (thing group) associated with the security profile.
     */
    public SecurityProfileTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileTargetMapping)) {
            return false;
        }
        SecurityProfileTargetMapping other = (SecurityProfileTargetMapping) obj;
        return Objects.equals(securityProfileIdentifier(), other.securityProfileIdentifier())
                && Objects.equals(target(), other.target());
    }

    @Override
    public String toString() {
        return ToString.builder("SecurityProfileTargetMapping").add("SecurityProfileIdentifier", securityProfileIdentifier())
                .add("Target", target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileIdentifier":
            return Optional.ofNullable(clazz.cast(securityProfileIdentifier()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityProfileTargetMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityProfileTargetMapping> {
        /**
         * <p>
         * Information that identifies the security profile.
         * </p>
         * 
         * @param securityProfileIdentifier
         *        Information that identifies the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIdentifier(SecurityProfileIdentifier securityProfileIdentifier);

        /**
         * <p>
         * Information that identifies the security profile.
         * </p>
         * This is a convenience that creates an instance of the {@link SecurityProfileIdentifier.Builder} avoiding the
         * need to create one manually via {@link SecurityProfileIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link SecurityProfileIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #securityProfileIdentifier(SecurityProfileIdentifier)}.
         * 
         * @param securityProfileIdentifier
         *        a consumer that will call methods on {@link SecurityProfileIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileIdentifier(SecurityProfileIdentifier)
         */
        default Builder securityProfileIdentifier(Consumer<SecurityProfileIdentifier.Builder> securityProfileIdentifier) {
            return securityProfileIdentifier(SecurityProfileIdentifier.builder().applyMutation(securityProfileIdentifier).build());
        }

        /**
         * <p>
         * Information about the target (thing group) associated with the security profile.
         * </p>
         * 
         * @param target
         *        Information about the target (thing group) associated with the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(SecurityProfileTarget target);

        /**
         * <p>
         * Information about the target (thing group) associated with the security profile.
         * </p>
         * This is a convenience that creates an instance of the {@link SecurityProfileTarget.Builder} avoiding the need
         * to create one manually via {@link SecurityProfileTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link SecurityProfileTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #target(SecurityProfileTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link SecurityProfileTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(SecurityProfileTarget)
         */
        default Builder target(Consumer<SecurityProfileTarget.Builder> target) {
            return target(SecurityProfileTarget.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SecurityProfileIdentifier securityProfileIdentifier;

        private SecurityProfileTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileTargetMapping model) {
            securityProfileIdentifier(model.securityProfileIdentifier);
            target(model.target);
        }

        public final SecurityProfileIdentifier.Builder getSecurityProfileIdentifier() {
            return securityProfileIdentifier != null ? securityProfileIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder securityProfileIdentifier(SecurityProfileIdentifier securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier;
            return this;
        }

        public final void setSecurityProfileIdentifier(SecurityProfileIdentifier.BuilderImpl securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier != null ? securityProfileIdentifier.build() : null;
        }

        public final SecurityProfileTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(SecurityProfileTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(SecurityProfileTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public SecurityProfileTargetMapping build() {
            return new SecurityProfileTargetMapping(this);
        }
    }
}
