/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetV2LoggingOptionsRequest extends IotRequest implements
        ToCopyableBuilder<SetV2LoggingOptionsRequest.Builder, SetV2LoggingOptionsRequest> {
    private final String roleArn;

    private final String defaultLogLevel;

    private final Boolean disableAllLogs;

    private SetV2LoggingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.defaultLogLevel = builder.defaultLogLevel;
        this.disableAllLogs = builder.disableAllLogs;
    }

    /**
     * <p>
     * The ARN of the role that allows IoT to write to Cloudwatch logs.
     * </p>
     * 
     * @return The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The default logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The default logging level.
     * @see LogLevel
     */
    public LogLevel defaultLogLevel() {
        return LogLevel.fromValue(defaultLogLevel);
    }

    /**
     * <p>
     * The default logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The default logging level.
     * @see LogLevel
     */
    public String defaultLogLevelAsString() {
        return defaultLogLevel;
    }

    /**
     * <p>
     * If true all logs are disabled. The default is false.
     * </p>
     * 
     * @return If true all logs are disabled. The default is false.
     */
    public Boolean disableAllLogs() {
        return disableAllLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disableAllLogs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetV2LoggingOptionsRequest)) {
            return false;
        }
        SetV2LoggingOptionsRequest other = (SetV2LoggingOptionsRequest) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(defaultLogLevelAsString(), other.defaultLogLevelAsString())
                && Objects.equals(disableAllLogs(), other.disableAllLogs());
    }

    @Override
    public String toString() {
        return ToString.builder("SetV2LoggingOptionsRequest").add("RoleArn", roleArn())
                .add("DefaultLogLevel", defaultLogLevelAsString()).add("DisableAllLogs", disableAllLogs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "defaultLogLevel":
            return Optional.ofNullable(clazz.cast(defaultLogLevelAsString()));
        case "disableAllLogs":
            return Optional.ofNullable(clazz.cast(disableAllLogs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IotRequest.Builder, CopyableBuilder<Builder, SetV2LoggingOptionsRequest> {
        /**
         * <p>
         * The ARN of the role that allows IoT to write to Cloudwatch logs.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that allows IoT to write to Cloudwatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The default logging level.
         * </p>
         * 
         * @param defaultLogLevel
         *        The default logging level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(String defaultLogLevel);

        /**
         * <p>
         * The default logging level.
         * </p>
         * 
         * @param defaultLogLevel
         *        The default logging level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(LogLevel defaultLogLevel);

        /**
         * <p>
         * If true all logs are disabled. The default is false.
         * </p>
         * 
         * @param disableAllLogs
         *        If true all logs are disabled. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAllLogs(Boolean disableAllLogs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String roleArn;

        private String defaultLogLevel;

        private Boolean disableAllLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(SetV2LoggingOptionsRequest model) {
            super(model);
            roleArn(model.roleArn);
            defaultLogLevel(model.defaultLogLevel);
            disableAllLogs(model.disableAllLogs);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDefaultLogLevel() {
            return defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel.toString());
            return this;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        public final Boolean getDisableAllLogs() {
            return disableAllLogs;
        }

        @Override
        public final Builder disableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
            return this;
        }

        public final void setDisableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetV2LoggingOptionsRequest build() {
            return new SetV2LoggingOptionsRequest(this);
        }
    }
}
