/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SigningProfileParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the code-signing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningProfileParameter implements StructuredPojo,
        ToCopyableBuilder<SigningProfileParameter.Builder, SigningProfileParameter> {
    private final String certificateArn;

    private final String platform;

    private final String certificatePathOnDevice;

    private SigningProfileParameter(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.platform = builder.platform;
        this.certificatePathOnDevice = builder.certificatePathOnDevice;
    }

    /**
     * <p>
     * Certificate ARN.
     * </p>
     * 
     * @return Certificate ARN.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The hardware platform of your device.
     * </p>
     * 
     * @return The hardware platform of your device.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The location of the code-signing certificate on your device.
     * </p>
     * 
     * @return The location of the code-signing certificate on your device.
     */
    public String certificatePathOnDevice() {
        return certificatePathOnDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePathOnDevice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfileParameter)) {
            return false;
        }
        SigningProfileParameter other = (SigningProfileParameter) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(platform(), other.platform())
                && Objects.equals(certificatePathOnDevice(), other.certificatePathOnDevice());
    }

    @Override
    public String toString() {
        return ToString.builder("SigningProfileParameter").add("CertificateArn", certificateArn()).add("Platform", platform())
                .add("CertificatePathOnDevice", certificatePathOnDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "certificatePathOnDevice":
            return Optional.ofNullable(clazz.cast(certificatePathOnDevice()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningProfileParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SigningProfileParameter> {
        /**
         * <p>
         * Certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        Certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The hardware platform of your device.
         * </p>
         * 
         * @param platform
         *        The hardware platform of your device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The location of the code-signing certificate on your device.
         * </p>
         * 
         * @param certificatePathOnDevice
         *        The location of the code-signing certificate on your device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePathOnDevice(String certificatePathOnDevice);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String platform;

        private String certificatePathOnDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfileParameter model) {
            certificateArn(model.certificateArn);
            platform(model.platform);
            certificatePathOnDevice(model.certificatePathOnDevice);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getCertificatePathOnDevice() {
            return certificatePathOnDevice;
        }

        @Override
        public final Builder certificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
            return this;
        }

        public final void setCertificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
        }

        @Override
        public SigningProfileParameter build() {
            return new SigningProfileParameter(this);
        }
    }
}
